/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.exception.InvalidOauthTokenException;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.UserReader;
import edu.ksu.canvas.interfaces.UserWriter;
import edu.ksu.canvas.model.User;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.GetUsersInCourseOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;

public class UserImpl
extends BaseImpl<User, UserReader, UserWriter>
implements UserReader,
UserWriter {
    private static final Logger LOG = Logger.getLogger(UserImpl.class);

    public UserImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize);
    }

    @Override
    public Optional<User> createUser(User user) throws InvalidOauthTokenException, IOException {
        String createdUrl = this.buildCanvasUrl("accounts/1/users", Collections.emptyMap());
        LOG.debug((Object)("create URl for user creation : " + createdUrl));
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, createdUrl, user.toPostMap());
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.debug((Object)("Failed to create user, error message: " + response.toString()));
            return Optional.empty();
        }
        return this.responseParser.parseToObject(User.class, response);
    }

    @Override
    public Optional<User> updateUser(User user) throws InvalidOauthTokenException, IOException {
        HashMap<String, List<String>> postParameters = new HashMap<String, List<String>>();
        postParameters.put("name", Collections.singletonList(user.getName()));
        postParameters.put("pseudonym[unique_id]", Collections.singletonList(user.getLoginId()));
        String createdUrl = this.buildCanvasUrl("accounts/" + String.valueOf(user.getId()) + "/users", Collections.emptyMap());
        LOG.debug((Object)("create URl for user creation : " + createdUrl));
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, createdUrl, postParameters);
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.debug((Object)("Failed to create user, error message: " + response.toString()));
            return Optional.empty();
        }
        return this.responseParser.parseToObject(User.class, response);
    }

    @Override
    public List<User> getUsersInCourse(GetUsersInCourseOptions options) throws IOException {
        LOG.debug((Object)("Retrieving users in course " + options.getCourseId()));
        String url = this.buildCanvasUrl("courses/" + options.getCourseId() + "/users", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<User>>(){}.getType();
    }

    @Override
    protected Class<User> objectType() {
        return User.class;
    }
}

