/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.enums.SectionIncludes;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.SectionReader;
import edu.ksu.canvas.interfaces.SectionWriter;
import edu.ksu.canvas.model.Section;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class SectionsImpl
extends BaseImpl<Section, SectionReader, SectionWriter>
implements SectionReader {
    private static final Logger LOG = Logger.getLogger(SectionReader.class);

    public SectionsImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize);
    }

    @Override
    public List<Section> listCourseSections(String courseId, List<SectionIncludes> includes) throws IOException {
        LOG.debug((Object)("Looking up sections for course " + courseId));
        ImmutableMap parameters = ImmutableMap.builder().put((Object)"include[]", includes.stream().map(Enum::name).collect(Collectors.toList())).build();
        String url = this.buildCanvasUrl("/courses/" + courseId + "/sections", (Map<String, List<String>>)parameters);
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<Section> getSingleSection(String sectionId) throws IOException {
        LOG.debug((Object)("getting section " + sectionId));
        String url = this.buildCanvasUrl("sections/" + sectionId, new HashMap<String, List<String>>());
        Response response = this.canvasMessenger.getSingleResponseFromCanvas(this.oauthToken, url);
        return this.responseParser.parseToObject(Section.class, response);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Section>>(){}.getType();
    }

    @Override
    protected Class<Section> objectType() {
        return Section.class;
    }
}

