/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.impl.GsonResponseParser;
import edu.ksu.canvas.interfaces.QuizSubmissionReader;
import edu.ksu.canvas.interfaces.QuizSubmissionWriter;
import edu.ksu.canvas.model.assignment.QuizSubmission;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.CompleteQuizSubmissionOptions;
import edu.ksu.canvas.requestOptions.StartQuizSubmissionOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class QuizSubmissionImpl
extends BaseImpl<QuizSubmission, QuizSubmissionReader, QuizSubmissionWriter>
implements QuizSubmissionReader,
QuizSubmissionWriter {
    private static final Logger LOG = Logger.getLogger(QuizSubmissionImpl.class);

    public QuizSubmissionImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize);
    }

    @Override
    public List<QuizSubmission> getQuizSubmissions(String courseId, String quizId) throws IOException {
        String url = this.buildCanvasUrl("courses/" + courseId + "/quizzes/" + quizId + "/submissions", Collections.emptyMap());
        List<Response> responses = this.canvasMessenger.getFromCanvas(this.oauthToken, url);
        return this.parseQuizSubmissionList(responses);
    }

    @Override
    public Optional<QuizSubmission> startQuizSubmission(StartQuizSubmissionOptions options) throws IOException {
        String url = this.buildCanvasUrl("courses/" + options.getCourseId() + "/quizzes/" + options.getQuizId() + "/submissions", options.getOptionsMap());
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, url, Collections.emptyMap());
        return Optional.of(this.parseQuizSubmissionList(response).get(0));
    }

    @Override
    public Optional<QuizSubmission> completeQuizSubmission(CompleteQuizSubmissionOptions options) throws IOException {
        LOG.debug((Object)("completing quiz submission for user/course/quiz: " + this.masqueradeAs + "/" + options.getCourseId() + "/" + options.getQuizId()));
        String url = this.buildCanvasUrl("courses/" + options.getCourseId() + "/quizzes/" + options.getQuizId() + "/submissions/" + options.getSubmissionId() + "/complete", options.getOptionsMap());
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, url, Collections.emptyMap());
        return Optional.of(this.parseQuizSubmissionList(response).get(0));
    }

    private List<QuizSubmission> parseQuizSubmissionList(List<Response> responses) {
        return responses.stream().map(this::parseQuizSubmissionList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<QuizSubmission> parseQuizSubmissionList(Response response) {
        QuizSubmissionListWrapper wrapper = (QuizSubmissionListWrapper)GsonResponseParser.getDefaultGsonParser().fromJson(response.getContent(), QuizSubmissionListWrapper.class);
        return wrapper.getQuiz_submissions();
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<QuizSubmission>>(){}.getType();
    }

    @Override
    protected Class<QuizSubmission> objectType() {
        return QuizSubmission.class;
    }

    private class QuizSubmissionListWrapper {
        private List<QuizSubmission> quiz_submissions;

        private QuizSubmissionListWrapper() {
        }

        public List<QuizSubmission> getQuiz_submissions() {
            return this.quiz_submissions;
        }

        public void setQuiz_submissions(List<QuizSubmission> quiz_submissions) {
            this.quiz_submissions = quiz_submissions;
        }
    }
}

