/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.interfaces.ResponseParser;
import edu.ksu.canvas.net.Response;
import java.lang.reflect.Type;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class GsonResponseParser
implements ResponseParser {
    private static final Logger LOG = Logger.getLogger(GsonResponseParser.class);

    @Override
    public <T> List<T> parseToList(Type type, Response response) {
        Gson gson = GsonResponseParser.getDefaultGsonParser();
        return (List)gson.fromJson(response.getContent(), type);
    }

    @Override
    public <T> Optional<T> parseToObject(Class<T> clazz, Response response) {
        Gson gson = GsonResponseParser.getDefaultGsonParser();
        return Optional.of(gson.fromJson(response.getContent(), clazz));
    }

    @Override
    public <T> Map<String, T> parseToMap(Class<T> clazz, Response response) {
        Gson gson = GsonResponseParser.getDefaultGsonParser();
        Type mapType = new TypeToken<Map<String, T>>(){}.getType();
        return (Map)gson.fromJson(response.getContent(), mapType);
    }

    public static Gson getDefaultGsonParser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json == null || StringUtils.isBlank((CharSequence)json.getAsString())) {
                    return null;
                }
                try {
                    ZonedDateTime zdt = ZonedDateTime.parse(json.getAsString());
                    return Date.from(zdt.toInstant());
                }
                catch (DateTimeParseException e) {
                    LOG.error((Object)("error parsing date from Canvas: " + json.getAsString()));
                    throw new JsonParseException((Throwable)e);
                }
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == null) {
                    return null;
                }
                String dateString = ZonedDateTime.ofInstant(src.toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_INSTANT);
                return new JsonPrimitive(dateString);
            }
        });
        return gsonBuilder.create();
    }
}

