/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.exception.InvalidOauthTokenException;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.CourseReader;
import edu.ksu.canvas.interfaces.EnrollmentReader;
import edu.ksu.canvas.interfaces.EnrollmentWriter;
import edu.ksu.canvas.model.Enrollment;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.GetEnrollmentOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;

public class EnrollmentImpl
extends BaseImpl<Enrollment, EnrollmentReader, EnrollmentWriter>
implements EnrollmentReader,
EnrollmentWriter {
    private static final Logger LOG = Logger.getLogger(CourseReader.class);

    public EnrollmentImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize);
    }

    @Override
    public List<Enrollment> getUserEnrollments(GetEnrollmentOptions options) throws IOException {
        LOG.debug((Object)("Retrieving user enrollments for user " + options.getObjectId()));
        String url = this.buildCanvasUrl("users/" + options.getObjectId() + "/enrollments", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Enrollment> getSectionEnrollments(GetEnrollmentOptions options) throws IOException {
        LOG.debug((Object)("Retrieving section enrollments for section " + options.getObjectId()));
        String url = this.buildCanvasUrl("sections/" + options.getObjectId() + "/enrollments", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Enrollment> getCourseEnrollments(GetEnrollmentOptions options) throws IOException {
        LOG.debug((Object)("Retrieving course enrollments for course " + options.getObjectId()));
        String url = this.buildCanvasUrl("courses/" + options.getObjectId() + "/enrollments", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<Enrollment> enrollUser(String courseId, String userId) throws InvalidOauthTokenException, IOException {
        HashMap<String, List<String>> courseMap = new HashMap<String, List<String>>();
        courseMap.put("enrollment[user_id]", Collections.singletonList(String.valueOf(userId)));
        String createdUrl = this.buildCanvasUrl("courses/" + courseId + "/enrollments", Collections.emptyMap());
        LOG.debug((Object)("create URl for course enrollments: " + createdUrl));
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, createdUrl, courseMap);
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.debug((Object)("Failed to enroll in course, error message: " + response.toString()));
            return Optional.empty();
        }
        return this.responseParser.parseToObject(Enrollment.class, response);
    }

    @Override
    public Optional<Enrollment> dropUser(String courseId, String enrollmentId) throws InvalidOauthTokenException, IOException {
        HashMap<String, List<String>> postParams = new HashMap<String, List<String>>();
        postParams.put("task", Collections.singletonList("delete"));
        String createdUrl = this.buildCanvasUrl("courses/" + courseId + "/enrollments/" + enrollmentId, Collections.emptyMap());
        LOG.debug((Object)("create URl for course enrollments: " + createdUrl));
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, createdUrl, postParams);
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.debug((Object)("Failed to enroll in course, error message: " + response.toString()));
            return Optional.empty();
        }
        return this.responseParser.parseToObject(Enrollment.class, response);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Enrollment>>(){}.getType();
    }

    @Override
    protected Class<Enrollment> objectType() {
        return Enrollment.class;
    }
}

