/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.CourseReader;
import edu.ksu.canvas.interfaces.CourseWriter;
import edu.ksu.canvas.model.Course;
import edu.ksu.canvas.model.status.Delete;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.GetSingleCourseOptions;
import edu.ksu.canvas.requestOptions.ListActiveCoursesInAccountOptions;
import edu.ksu.canvas.requestOptions.ListCurrentUserCoursesOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;

public class CourseImpl
extends BaseImpl<Course, CourseReader, CourseWriter>
implements CourseReader,
CourseWriter {
    private static final Logger LOG = Logger.getLogger(CourseReader.class);

    public CourseImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize);
    }

    @Override
    public List<Course> listCurrentUserCourses(ListCurrentUserCoursesOptions options) throws IOException {
        LOG.info((Object)"listing courses for user");
        String url = this.buildCanvasUrl("courses/", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<Course> getSingleCourse(GetSingleCourseOptions options) throws IOException {
        LOG.debug((Object)("getting course " + options.getCourseId()));
        String url = this.buildCanvasUrl("courses/" + options.getCourseId(), options.getOptionsMap());
        LOG.debug((Object)("Final URL of API call: " + url));
        return this.retrieveCourseFromCanvas(this.oauthToken, url);
    }

    private Optional<Course> retrieveCourseFromCanvas(OauthToken oauthToken, String url) throws IOException {
        Response response = this.canvasMessenger.getSingleResponseFromCanvas(oauthToken, url);
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            return Optional.empty();
        }
        return this.responseParser.parseToObject(Course.class, response);
    }

    @Override
    public Optional<Course> createCourse(String accountId, Course course) throws IOException {
        LOG.debug((Object)"creating course");
        String url = this.buildCanvasUrl("accounts/" + accountId + "/courses", Collections.emptyMap());
        Response response = this.canvasMessenger.sendJsonPostToCanvas(this.oauthToken, url, course.toJsonObject());
        return this.responseParser.parseToObject(Course.class, response);
    }

    @Override
    public Boolean deleteCourse(String courseId) throws IOException {
        HashMap<String, List<String>> postParams = new HashMap<String, List<String>>();
        postParams.put("event", Collections.singletonList("delete"));
        String createdUrl = this.buildCanvasUrl("courses/" + courseId, Collections.emptyMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, createdUrl, postParams);
        LOG.debug((Object)("response " + response.toString()));
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.debug((Object)("Failed to delete course, error message: " + response.toString()));
            return false;
        }
        Optional<Delete> responseParsed = this.responseParser.parseToObject(Delete.class, response);
        return responseParsed.map(r -> r.getDelete()).orElse(false);
    }

    @Override
    public List<Course> listActiveCoursesInAccount(ListActiveCoursesInAccountOptions options) throws IOException {
        String url = this.buildCanvasUrl("accounts/" + options.getAccountId() + "/courses", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Course>>(){}.getType();
    }

    @Override
    protected Class<Course> objectType() {
        return Course.class;
    }
}

