/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.AccountReader;
import edu.ksu.canvas.interfaces.CanvasWriter;
import edu.ksu.canvas.model.Account;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.GetSubAccountsOptions;
import edu.ksu.canvas.requestOptions.ListAccountOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;

public class AccountImpl
extends BaseImpl<Account, AccountReader, CanvasWriter>
implements AccountReader {
    private static final Logger LOG = Logger.getLogger(AccountImpl.class);

    public AccountImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize);
    }

    @Override
    public Optional<Account> getSingleAccount(String accountId) throws IOException {
        LOG.debug((Object)("getting account " + accountId));
        String url = this.buildCanvasUrl("accounts/" + accountId, Collections.emptyMap());
        Response response = this.canvasMessenger.getSingleResponseFromCanvas(this.oauthToken, url);
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            return Optional.empty();
        }
        return this.responseParser.parseToObject(Account.class, response);
    }

    @Override
    public List<Account> listAccounts(ListAccountOptions options) throws IOException {
        LOG.debug((Object)"Listing accounts for current user ");
        String url = this.buildCanvasUrl("accounts", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Account> getSubAccounts(GetSubAccountsOptions options) throws IOException {
        LOG.debug((Object)("Getting list of sub-accounts for account " + options.getAccountId()));
        String url = this.buildCanvasUrl("accounts/" + options.getAccountId() + "/sub_accounts", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Account> listAccountsForCourseAdmins() throws IOException {
        LOG.debug((Object)"Getting list of accounts by admin course enrollments");
        String url = this.buildCanvasUrl("course_accounts", Collections.emptyMap());
        return this.getListFromCanvas(url);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Account>>(){}.getType();
    }

    @Override
    protected Class<Account> objectType() {
        return Account.class;
    }
}

