/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas;

import edu.ksu.canvas.CanvasApiFactory;
import edu.ksu.canvas.interfaces.AccountReader;
import edu.ksu.canvas.interfaces.CourseReader;
import edu.ksu.canvas.model.Account;
import edu.ksu.canvas.model.Course;
import edu.ksu.canvas.oauth.NonRefreshableOauthToken;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.ListCurrentUserCoursesOptions;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class TestLauncher {
    private static final Logger LOG = Logger.getLogger(TestLauncher.class);
    private String canvasUrl;
    private OauthToken oauthToken;

    public static void main(String[] args) {
        String canvasUrl = null;
        String oauthToken = null;
        if (args.length != 4) {
            LOG.error((Object)"Must supply two arguments: --canvas_url http://instance.instructure.com --token [Manually generated token]");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            if ("--canvas_url".equals(args[i])) {
                canvasUrl = args[i + 1];
            }
            if (!"--token".equals(args[i])) continue;
            oauthToken = args[i + 1];
        }
        if (canvasUrl == null || oauthToken == null) {
            LOG.error((Object)"Canvas URL or OAuth token is blank. Must have to continue!");
            System.exit(1);
        }
        TestLauncher launcher = new TestLauncher(canvasUrl, oauthToken);
        try {
            launcher.getRootAccount();
            launcher.getOwnCourses();
        }
        catch (Exception e) {
            LOG.error((Object)"Problem while executing example methods", (Throwable)e);
        }
    }

    public TestLauncher(String canvasUrl, String tokenString) {
        this.canvasUrl = canvasUrl;
        this.oauthToken = new NonRefreshableOauthToken(tokenString);
    }

    public void getRootAccount() throws IOException {
        CanvasApiFactory apiFactory = new CanvasApiFactory(this.canvasUrl);
        AccountReader acctReader = apiFactory.getReader(AccountReader.class, this.oauthToken);
        Account rootAccount = acctReader.getSingleAccount("1").get();
        LOG.info((Object)("Got account from Canvas: " + rootAccount.getName()));
    }

    public void getOwnCourses() throws IOException {
        CanvasApiFactory apiFactory = new CanvasApiFactory(this.canvasUrl);
        CourseReader courseReader = apiFactory.getReader(CourseReader.class, this.oauthToken);
        List<Course> myCourses = courseReader.listCurrentUserCourses(new ListCurrentUserCoursesOptions());
        LOG.info((Object)("Got " + myCourses.size() + " courses back from Canvas: "));
        for (Course course : myCourses) {
            LOG.info((Object)("  " + course.getName()));
        }
    }
}

