/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas;

import edu.ksu.canvas.impl.AccountImpl;
import edu.ksu.canvas.impl.AssignmentImpl;
import edu.ksu.canvas.impl.AssignmentOverrideImpl;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.impl.ConversationImpl;
import edu.ksu.canvas.impl.CourseImpl;
import edu.ksu.canvas.impl.EnrollmentImpl;
import edu.ksu.canvas.impl.PageImpl;
import edu.ksu.canvas.impl.QuizImpl;
import edu.ksu.canvas.impl.QuizQuestionImpl;
import edu.ksu.canvas.impl.QuizSubmissionImpl;
import edu.ksu.canvas.impl.QuizSubmissionQuestionImpl;
import edu.ksu.canvas.impl.SectionsImpl;
import edu.ksu.canvas.impl.UserImpl;
import edu.ksu.canvas.interfaces.AccountReader;
import edu.ksu.canvas.interfaces.AssignmentOverrideReader;
import edu.ksu.canvas.interfaces.AssignmentOverrideWriter;
import edu.ksu.canvas.interfaces.AssignmentReader;
import edu.ksu.canvas.interfaces.AssignmentWriter;
import edu.ksu.canvas.interfaces.CanvasReader;
import edu.ksu.canvas.interfaces.CanvasWriter;
import edu.ksu.canvas.interfaces.ConversationReader;
import edu.ksu.canvas.interfaces.ConversationWriter;
import edu.ksu.canvas.interfaces.CourseReader;
import edu.ksu.canvas.interfaces.CourseWriter;
import edu.ksu.canvas.interfaces.EnrollmentReader;
import edu.ksu.canvas.interfaces.EnrollmentWriter;
import edu.ksu.canvas.interfaces.PageReader;
import edu.ksu.canvas.interfaces.PageWriter;
import edu.ksu.canvas.interfaces.QuizQuestionReader;
import edu.ksu.canvas.interfaces.QuizQuestionWriter;
import edu.ksu.canvas.interfaces.QuizReader;
import edu.ksu.canvas.interfaces.QuizSubmissionQuestionReader;
import edu.ksu.canvas.interfaces.QuizSubmissionQuestionWriter;
import edu.ksu.canvas.interfaces.QuizSubmissionReader;
import edu.ksu.canvas.interfaces.QuizSubmissionWriter;
import edu.ksu.canvas.interfaces.QuizWriter;
import edu.ksu.canvas.interfaces.SectionReader;
import edu.ksu.canvas.interfaces.UserReader;
import edu.ksu.canvas.interfaces.UserWriter;
import edu.ksu.canvas.net.RefreshingRestClient;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CanvasApiFactory {
    private static final Logger LOG = Logger.getLogger(CanvasApiFactory.class);
    public static final Integer CANVAS_API_VERSION = 1;
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 5000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 120000;
    private String canvasBaseUrl;
    private int connectTimeout;
    private int readTimeout;
    Map<Class<? extends CanvasReader>, Class<? extends BaseImpl>> readerMap;
    Map<Class<? extends CanvasWriter>, Class<? extends BaseImpl>> writerMap;

    public CanvasApiFactory(String canvasBaseUrl) {
        LOG.debug((Object)("Creating Canvas API factory with base URL: " + canvasBaseUrl));
        this.canvasBaseUrl = canvasBaseUrl;
        this.connectTimeout = 5000;
        this.readTimeout = 120000;
        this.setupClassMap();
    }

    public CanvasApiFactory(String canvasBaseUrl, int connectTimeout, int readTimeout) {
        this.canvasBaseUrl = canvasBaseUrl;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.setupClassMap();
    }

    public <T extends CanvasReader> T getReader(Class<T> type, OauthToken oauthToken) {
        return this.getReader(type, oauthToken, null);
    }

    public <T extends CanvasReader> T getReader(Class<T> type, OauthToken oauthToken, Integer paginationPageSize) {
        LOG.debug((Object)("Factory call to instantiate class: " + type.getName()));
        RefreshingRestClient restClient = new RefreshingRestClient();
        Class<? extends BaseImpl> concreteClass = this.readerMap.get(type);
        if (concreteClass == null) {
            throw new UnsupportedOperationException("No implementation for requested interface found: " + type.getName());
        }
        LOG.debug((Object)("got class: " + concreteClass));
        try {
            Constructor<? extends BaseImpl> constructor = concreteClass.getConstructor(String.class, Integer.class, OauthToken.class, RestClient.class, Integer.TYPE, Integer.TYPE, Integer.class);
            return (T)constructor.newInstance(this.canvasBaseUrl, CANVAS_API_VERSION, oauthToken, restClient, this.connectTimeout, this.readTimeout, paginationPageSize);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unknown error instantiating the concrete API class: " + type.getName(), e);
        }
    }

    public <T extends CanvasWriter> T getWriter(Class<T> type, OauthToken oauthToken) {
        LOG.debug((Object)("Factory call to instantiate class: " + type.getName()));
        RefreshingRestClient restClient = new RefreshingRestClient();
        Class<? extends BaseImpl> concreteClass = this.writerMap.get(type);
        if (concreteClass == null) {
            throw new UnsupportedOperationException("No implementation for requested interface found: " + type.getName());
        }
        LOG.debug((Object)("got class: " + concreteClass));
        try {
            Constructor<? extends BaseImpl> constructor = concreteClass.getConstructor(String.class, Integer.class, OauthToken.class, RestClient.class, Integer.TYPE, Integer.TYPE, Integer.class);
            return (T)constructor.newInstance(this.canvasBaseUrl, CANVAS_API_VERSION, oauthToken, restClient, this.connectTimeout, this.readTimeout, null);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unknown error instantiating the concrete API class: " + type.getName(), e);
        }
    }

    private void setupClassMap() {
        this.readerMap = new HashMap<Class<? extends CanvasReader>, Class<? extends BaseImpl>>();
        this.writerMap = new HashMap<Class<? extends CanvasWriter>, Class<? extends BaseImpl>>();
        this.readerMap.put(AccountReader.class, AccountImpl.class);
        this.readerMap.put(AssignmentOverrideReader.class, AssignmentOverrideImpl.class);
        this.readerMap.put(AssignmentReader.class, AssignmentImpl.class);
        this.readerMap.put(ConversationReader.class, ConversationImpl.class);
        this.readerMap.put(CourseReader.class, CourseImpl.class);
        this.readerMap.put(EnrollmentReader.class, EnrollmentImpl.class);
        this.readerMap.put(QuizQuestionReader.class, QuizQuestionImpl.class);
        this.readerMap.put(QuizReader.class, QuizImpl.class);
        this.readerMap.put(QuizSubmissionQuestionReader.class, QuizSubmissionQuestionImpl.class);
        this.readerMap.put(QuizSubmissionReader.class, QuizSubmissionImpl.class);
        this.readerMap.put(SectionReader.class, SectionsImpl.class);
        this.readerMap.put(UserReader.class, UserImpl.class);
        this.readerMap.put(PageReader.class, PageImpl.class);
        this.writerMap.put(AssignmentOverrideWriter.class, AssignmentOverrideImpl.class);
        this.writerMap.put(AssignmentWriter.class, AssignmentImpl.class);
        this.writerMap.put(ConversationWriter.class, ConversationImpl.class);
        this.writerMap.put(CourseWriter.class, CourseImpl.class);
        this.writerMap.put(EnrollmentWriter.class, EnrollmentImpl.class);
        this.writerMap.put(QuizQuestionWriter.class, QuizQuestionImpl.class);
        this.writerMap.put(QuizWriter.class, QuizImpl.class);
        this.writerMap.put(QuizSubmissionQuestionWriter.class, QuizSubmissionQuestionImpl.class);
        this.writerMap.put(QuizSubmissionWriter.class, QuizSubmissionImpl.class);
        this.writerMap.put(UserWriter.class, UserImpl.class);
        this.writerMap.put(PageWriter.class, PageImpl.class);
    }
}

