/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;

public class ServiceHelper {
    private ServiceHelper() {
    }

    public static <F> F loadService(Class<F> factoryClass, Supplier<F> defaultBuilder) {
        return (F)ServiceHelper.loadFactoryService(factoryClass, f -> f, defaultBuilder);
    }

    public static <F, T> T loadFactoryService(Class<F> factoryClass, Function<F, T> factoryBuilder, Supplier<T> defaultBuilder) {
        Iterator<F> iterator = ServiceHelper.loadFactories(factoryClass).iterator();
        if (iterator.hasNext()) {
            F factory = iterator.next();
            return factoryBuilder.apply(factory);
        }
        return defaultBuilder.get();
    }

    public static <T, F extends Supplier<T>> T loadFactoryService(Class<F> factoryClass, Supplier<T> defaultBuilder) {
        Iterator<F> iterator = ServiceHelper.loadFactories(factoryClass).iterator();
        if (iterator.hasNext()) {
            Supplier factory = (Supplier)iterator.next();
            return factory.get();
        }
        return defaultBuilder.get();
    }

    public static <T> Collection<T> loadFactories(Class<T> clazz) {
        return ServiceHelper.loadFactories(clazz, null);
    }

    public static <T> Collection<T> loadFactories(Class<T> clazz, ClassLoader classLoader) {
        List<T> result = classLoader != null ? ServiceHelper.loadAll(ServiceLoader.load(clazz, classLoader)) : ServiceHelper.loadAll(ServiceLoader.load(clazz));
        if (result.isEmpty()) {
            result = ServiceHelper.loadAll(ServiceLoader.load(clazz, ServiceHelper.class.getClassLoader()));
        }
        return result;
    }

    private static <T> List<T> loadAll(ServiceLoader<T> loader) {
        ArrayList list = new ArrayList();
        loader.iterator().forEachRemaining(list::add);
        return list;
    }
}

