/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolMemoryId;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.internal.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ToolSpecifications {
    private ToolSpecifications() {
    }

    public static List<ToolSpecification> toolSpecificationsFrom(Object objectWithTools) {
        return Arrays.stream(objectWithTools.getClass().getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Tool.class)).map(ToolSpecifications::toolSpecificationFrom).collect(Collectors.toList());
    }

    public static ToolSpecification toolSpecificationFrom(Method method) {
        Tool annotation = method.getAnnotation(Tool.class);
        String name = Utils.isNullOrBlank(annotation.name()) ? method.getName() : annotation.name();
        String description = String.join((CharSequence)"\n", annotation.value());
        ToolSpecification.Builder builder = ToolSpecification.builder().name(name).description(description);
        for (Parameter parameter : method.getParameters()) {
            if (parameter.isAnnotationPresent(ToolMemoryId.class)) continue;
            builder.addParameter(parameter.getName(), ToolSpecifications.toJsonSchemaProperties(parameter));
        }
        return builder.build();
    }

    static Iterable<JsonSchemaProperty> toJsonSchemaProperties(Parameter parameter) {
        JsonSchemaProperty description;
        Class<?> type = parameter.getType();
        P annotation = parameter.getAnnotation(P.class);
        JsonSchemaProperty jsonSchemaProperty = description = annotation == null ? null : JsonSchemaProperty.description(annotation.value());
        if (type == String.class) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.STRING, description);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.BOOLEAN, description);
        }
        if (type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class || type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == BigInteger.class) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.INTEGER, description);
        }
        if (type == Float.TYPE || type == Float.class || type == Double.TYPE || type == Double.class || type == BigDecimal.class) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.NUMBER, description);
        }
        if (type.isArray() || type == List.class || type == Set.class) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.ARRAY, description);
        }
        if (type.isEnum()) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.STRING, JsonSchemaProperty.enums(type.getEnumConstants()), description);
        }
        return ToolSpecifications.removeNulls(JsonSchemaProperty.OBJECT, description);
    }

    static Iterable<JsonSchemaProperty> removeNulls(JsonSchemaProperty ... items) {
        return Arrays.stream(items).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

