/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BufferedReadOnlyFile
extends DecoratingReadOnlyFile {
    public static final int WINDOW_LEN = 8192;
    private long length;
    private long fp;
    private long windowOff;
    private final byte[] window;

    protected static long min(long a, long b) {
        return a < b ? a : b;
    }

    protected static long max(long a, long b) {
        return a < b ? b : a;
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(File file) throws IOException {
        this(null, file, 8192);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(File file, int windowLen) throws IOException {
        this(null, file, windowLen);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile rof) throws IOException {
        this(rof, null, 8192);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile rof, int windowLen) throws IOException {
        this(rof, null, windowLen);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private BufferedReadOnlyFile(@CheckForNull @WillCloseWhenClosed ReadOnlyFile rof, @CheckForNull File file, int windowLen) throws IOException {
        super(BufferedReadOnlyFile.check(rof, file, windowLen));
        this.fp = this.delegate.getFilePointer();
        this.window = new byte[windowLen];
        this.invalidateWindow();
        assert (0 < this.window.length);
    }

    private static ReadOnlyFile check(@CheckForNull @WillCloseWhenClosed ReadOnlyFile rof, @CheckForNull File file, int windowLen) throws FileNotFoundException {
        if (0 >= windowLen) {
            throw new IllegalArgumentException();
        }
        if (null != rof) {
            assert (null == file);
            return rof;
        }
        return new DefaultReadOnlyFile(file);
    }

    protected final void assertOpen() throws IOException {
        if (null == this.delegate) {
            throw new IOException("File is closed!");
        }
    }

    @Override
    public long length() throws IOException {
        this.assertOpen();
        long length = this.delegate.length();
        if (length != this.length) {
            this.length = length;
            this.invalidateWindow();
        }
        return length;
    }

    @Override
    public long getFilePointer() throws IOException {
        this.assertOpen();
        return this.fp;
    }

    @Override
    public void seek(long fp) throws IOException {
        this.assertOpen();
        if (fp < 0L) {
            throw new IOException("File pointer must not be negative!");
        }
        long length = this.length();
        if (fp > length) {
            throw new IOException("File pointer (" + fp + ") is larger than file length (" + length + ")!");
        }
        this.fp = fp;
    }

    @Override
    public int read() throws IOException {
        this.assertOpen();
        if (this.fp >= this.length()) {
            return -1;
        }
        this.positionWindow();
        return this.window[(int)(this.fp++ % (long)this.window.length)] & 0xFF;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        this.assertOpen();
        long length = this.length();
        if (this.fp >= length) {
            return -1;
        }
        if (0 > (off | len | buf.length - off - len)) {
            throw new IndexOutOfBoundsException();
        }
        int windowLen = this.window.length;
        int read = 0;
        int o = (int)(this.fp % (long)windowLen);
        if (o != 0) {
            this.positionWindow();
            read = Math.min(len, windowLen - o);
            read = (int)Math.min((long)read, length - this.fp);
            System.arraycopy(this.window, o, buf, off, read);
            this.fp += (long)read;
        }
        while (read + windowLen < len && this.fp + (long)windowLen <= length) {
            this.positionWindow();
            System.arraycopy(this.window, 0, buf, off + read, windowLen);
            read += windowLen;
            this.fp += (long)windowLen;
        }
        if (read < len && this.fp < length) {
            this.positionWindow();
            int n = (int)Math.min((long)(len - read), length - this.fp);
            System.arraycopy(this.window, 0, buf, off + read, n);
            read += n;
            this.fp += (long)n;
        }
        assert (read > 0);
        return read;
    }

    @Override
    public void close() throws IOException {
        if (null == this.delegate) {
            return;
        }
        this.delegate.close();
        this.delegate = null;
    }

    private void positionWindow() throws IOException {
        long fp = this.fp;
        int windowLen = this.window.length;
        long nextWindowOff = this.windowOff + (long)windowLen;
        if (this.windowOff <= fp && fp < nextWindowOff) {
            return;
        }
        try {
            int read;
            this.windowOff = fp / (long)windowLen * (long)windowLen;
            if (this.windowOff != nextWindowOff) {
                this.delegate.seek(this.windowOff);
            }
            int n = 0;
            while ((read = this.delegate.read(this.window, n, windowLen - n)) >= 0 && (n += read) < windowLen) {
            }
        }
        catch (IOException ioe) {
            this.windowOff = -windowLen - 1;
            throw ioe;
        }
    }

    private void invalidateWindow() {
        this.windowOff = Long.MIN_VALUE;
    }
}

