/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.sl;

import de.schlichtherle.truezip.fs.FsDefaultManager;
import de.schlichtherle.truezip.fs.FsFailSafeManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsManagerProvider;
import de.schlichtherle.truezip.fs.spi.FsManagerService;
import de.schlichtherle.truezip.util.ServiceLocator;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FsManagerLocator
implements FsManagerProvider {
    public static final FsManagerLocator SINGLETON = new FsManagerLocator();

    private FsManagerLocator() {
    }

    @Override
    public FsManager get() {
        return Boot.MANAGER;
    }

    private static final class Boot {
        static final FsManager MANAGER;

        private Boot() {
        }

        static {
            FsManager manager;
            Logger logger = Logger.getLogger(FsManagerLocator.class.getName(), FsManagerLocator.class.getName());
            ServiceLocator locator = new ServiceLocator(FsManagerLocator.class.getClassLoader());
            FsManagerService service = locator.getService(FsManagerService.class, null);
            if (null == service) {
                FsManagerService oldService = null;
                Iterator<FsManagerService> i = locator.getServices(FsManagerService.class);
                while (i.hasNext()) {
                    service = i.next();
                    logger.log(Level.CONFIG, "located", service);
                    if (null != oldService && oldService.getPriority() > service.getPriority()) {
                        service = oldService;
                    }
                    oldService = service;
                }
            }
            if (null != service) {
                manager = service.get();
                logger.log(Level.CONFIG, "provided", manager);
            } else {
                manager = new FsFailSafeManager(new FsDefaultManager());
                logger.log(Level.CONFIG, "default", manager);
            }
            MANAGER = manager;
        }
    }
}

