/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.util.ExceptionHandler;
import de.schlichtherle.truezip.util.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class FsResourceAccountant {
    private static final int INITIAL_CAPACITY = Maps.initialCapacity(Runtime.getRuntime().availableProcessors() * 10);
    @GuardedBy(value="lock")
    private static final ConcurrentMap<Closeable, Account> accounts = new ConcurrentHashMap<Closeable, Account>(INITIAL_CAPACITY, 0.75f, INITIAL_CAPACITY);
    private final Lock lock;
    private final Condition condition;

    FsResourceAccountant(Lock lock) {
        this.lock = lock;
        this.condition = this.lock.newCondition();
    }

    void startAccountingFor(@WillCloseWhenClosed Closeable resource) {
        if (null == accounts.get(resource)) {
            accounts.putIfAbsent(resource, new Account());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopAccountingFor(@WillNotClose Closeable resource) {
        if (null != accounts.remove(resource)) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int waitForeignResources(long timeout) {
        this.lock.lock();
        try {
            try {
                long toWait = TimeUnit.MILLISECONDS.toNanos(timeout);
                while (this.localResources() < this.totalResources()) {
                    if (0L < timeout) {
                        if (0L < toWait) {
                            toWait = this.condition.awaitNanos(toWait);
                            continue;
                        }
                        break;
                    }
                    this.condition.await();
                }
            }
            catch (InterruptedException cancel) {
                int tr = this.totalResources();
                if (0 == tr) {
                    Thread.currentThread().interrupt();
                }
                int n = tr;
                this.lock.unlock();
                return n;
            }
            int n = this.totalResources();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    int localResources() {
        int n = 0;
        Thread currentThread = Thread.currentThread();
        for (Account account : accounts.values()) {
            if (account.getAccountant() != this || account.owner != currentThread) continue;
            ++n;
        }
        return n;
    }

    int totalResources() {
        int n = 0;
        for (Account account : accounts.values()) {
            if (account.getAccountant() != this) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <X extends Exception> void closeAllResources(ExceptionHandler<? super IOException, X> handler) throws X {
        assert (null != handler);
        this.lock.lock();
        try {
            Iterator i = accounts.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Account account = (Account)entry.getValue();
                if (account.getAccountant() != this) continue;
                i.remove();
                try {
                    ((Closeable)entry.getKey()).close();
                }
                catch (IOException ex) {
                    handler.warn(ex);
                }
            }
        }
        finally {
            this.condition.signalAll();
            this.lock.unlock();
        }
    }

    private final class Account {
        final Thread owner = Thread.currentThread();

        private Account() {
        }

        FsResourceAccountant getAccountant() {
            return FsResourceAccountant.this;
        }
    }
}

