/*
 * Decompiled with CFR 0.152.
 */
package com.moebiusgames.pdfbox.table;

import com.moebiusgames.pdfbox.table.PDFTableBorder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public final class PDFUtils {
    public static final PDFTableBorder NO_BORDER = new PDFTableBorder();
    public static final float POINTS_PER_INCH = 72.0f;
    public static final float MM_TO_POINTS_72DPI = 2.8346457f;
    private static final Map<PDFont, PDFont> BOLD_FONT_VARIANTS = new HashMap<PDFont, PDFont>();

    public static PDFont getBoldVariant(PDFont font) {
        PDFont result = BOLD_FONT_VARIANTS.get(font);
        if (result == null) {
            result = PDType1Font.HELVETICA_BOLD;
        }
        return result;
    }

    public static byte[] renderPDF(PDDocument doc) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        doc.save((OutputStream)bOut);
        return bOut.toByteArray();
    }

    public static PDFont modifyFont(PDFont font, FontModifier ... modifiers) {
        return PDFUtils.modifyFont(font, new HashSet<FontModifier>(Arrays.asList(modifiers)));
    }

    public static PDFont modifyFont(PDFont font, Set<FontModifier> modifiers) {
        PDType1Font baseFont;
        if (font.equals((Object)PDType1Font.TIMES_ROMAN) || font.equals((Object)PDType1Font.TIMES_BOLD) || font.equals((Object)PDType1Font.TIMES_ITALIC) || font.equals((Object)PDType1Font.TIMES_BOLD_ITALIC)) {
            baseFont = PDType1Font.TIMES_ROMAN;
        } else if (font.equals((Object)PDType1Font.COURIER) || font.equals((Object)PDType1Font.COURIER_BOLD) || font.equals((Object)PDType1Font.COURIER_OBLIQUE) || font.equals((Object)PDType1Font.COURIER_BOLD_OBLIQUE)) {
            baseFont = PDType1Font.COURIER;
        } else if (font.equals((Object)PDType1Font.HELVETICA) || font.equals((Object)PDType1Font.HELVETICA_BOLD) || font.equals((Object)PDType1Font.HELVETICA_OBLIQUE) || font.equals((Object)PDType1Font.HELVETICA_BOLD_OBLIQUE)) {
            baseFont = PDType1Font.HELVETICA;
        } else {
            throw new IllegalArgumentException("This font is not supported");
        }
        if (baseFont == PDType1Font.TIMES_ROMAN) {
            if (modifiers.contains((Object)FontModifier.BOLD) && modifiers.contains((Object)FontModifier.ITALIC)) {
                return PDType1Font.TIMES_BOLD_ITALIC;
            }
            if (modifiers.contains((Object)FontModifier.BOLD)) {
                return PDType1Font.TIMES_BOLD;
            }
            if (modifiers.contains((Object)FontModifier.ITALIC)) {
                return PDType1Font.TIMES_ITALIC;
            }
            return baseFont;
        }
        if (baseFont == PDType1Font.COURIER) {
            if (modifiers.contains((Object)FontModifier.BOLD) && modifiers.contains((Object)FontModifier.ITALIC)) {
                return PDType1Font.COURIER_BOLD_OBLIQUE;
            }
            if (modifiers.contains((Object)FontModifier.BOLD)) {
                return PDType1Font.COURIER_BOLD;
            }
            if (modifiers.contains((Object)FontModifier.ITALIC)) {
                return PDType1Font.COURIER_OBLIQUE;
            }
            return baseFont;
        }
        if (modifiers.contains((Object)FontModifier.BOLD) && modifiers.contains((Object)FontModifier.ITALIC)) {
            return PDType1Font.HELVETICA_BOLD_OBLIQUE;
        }
        if (modifiers.contains((Object)FontModifier.BOLD)) {
            return PDType1Font.HELVETICA_BOLD;
        }
        if (modifiers.contains((Object)FontModifier.ITALIC)) {
            return PDType1Font.HELVETICA_OBLIQUE;
        }
        return baseFont;
    }

    private PDFUtils() {
    }

    static {
        NO_BORDER.setLineWidth(0.0f);
        BOLD_FONT_VARIANTS.put((PDFont)PDType1Font.COURIER, (PDFont)PDType1Font.COURIER_BOLD);
        BOLD_FONT_VARIANTS.put((PDFont)PDType1Font.HELVETICA, (PDFont)PDType1Font.HELVETICA_BOLD);
        BOLD_FONT_VARIANTS.put((PDFont)PDType1Font.TIMES_ROMAN, (PDFont)PDType1Font.TIMES_BOLD);
    }

    public static enum FontModifier {
        REGULAR,
        ITALIC,
        BOLD;

    }
}

