/*
 * Decompiled with CFR 0.152.
 */
package com.moebiusgames.pdfbox.table;

import com.moebiusgames.pdfbox.table.Align;
import com.moebiusgames.pdfbox.table.PDFTable;
import com.moebiusgames.pdfbox.table.PDFTableBorder;
import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class PDFTableColumn {
    private int fontSize = 10;
    private PDFont font = PDType1Font.HELVETICA;
    private Align align = Align.LEFT;
    private Integer headingFontSize = null;
    private PDFont headingFont = PDType1Font.HELVETICA_BOLD;
    private Align headingAlign = null;
    private Color headingFontColor = null;
    private Color headingBackgroundColor = null;
    private final float width;
    private PDFTableBorder borderLeft = new PDFTableBorder();
    private PDFTableBorder borderRight = new PDFTableBorder();
    private PDFTableBorder borderTop = new PDFTableBorder();
    private PDFTableBorder borderBottom = new PDFTableBorder();
    private float paddingLeft = 4.0f;
    private float paddingRight = 4.0f;
    private float paddingTop = 4.0f;
    private float paddingBottom = 4.0f;
    private Color fontColor = Color.BLACK;
    private Color backgroundColor = null;
    private float lineSpacingFactor = 0.2f;
    private String heading = "[N/A]";
    private Boolean underline = false;
    private final PDFTable table;

    PDFTableColumn(PDFTable table, float width) {
        this.table = table;
        this.width = width;
    }

    public String getHeading() {
        return this.heading;
    }

    public PDFTableColumn setHeading(String heading) {
        if (heading == null) {
            throw new IllegalArgumentException("null value not allowed");
        }
        this.heading = heading;
        return this;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public PDFTableColumn setFontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public PDFont getFont() {
        return this.font;
    }

    public PDFTableColumn setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public Align getAlign() {
        return this.align;
    }

    public PDFTableColumn setAlign(Align align) {
        this.align = align;
        return this;
    }

    public int getHeadingFontSize() {
        return this.headingFontSize != null ? this.headingFontSize.intValue() : this.getFontSize();
    }

    public PDFTableColumn setHeadingFontSize(Integer headingFontSize) {
        this.headingFontSize = headingFontSize;
        return this;
    }

    public PDFont getHeadingFont() {
        return this.headingFont != null ? this.headingFont : this.getFont();
    }

    public PDFTableColumn setHeadingFont(PDFont headingFont) {
        this.headingFont = headingFont;
        return this;
    }

    public Align getHeadingAlign() {
        return this.headingAlign != null ? this.headingAlign : this.getAlign();
    }

    public PDFTableColumn setHeadingAlign(Align headingAlign) {
        this.headingAlign = headingAlign;
        return this;
    }

    public Color getHeadingFontColor() {
        return this.headingFontColor != null ? this.headingFontColor : this.getFontColor();
    }

    public PDFTableColumn setHeadingFontColor(Color headingFontColor) {
        this.headingFontColor = headingFontColor;
        return this;
    }

    public Color getHeadingBackgroundColor() {
        return this.headingBackgroundColor != null ? this.headingBackgroundColor : this.getBackgroundColor();
    }

    public PDFTableColumn setHeadingBackgroundColor(Color headingBackgroundColor) {
        this.headingBackgroundColor = headingBackgroundColor;
        return this;
    }

    public float getWidth() {
        return this.width;
    }

    public PDFTableBorder getBorderLeft() {
        return this.borderLeft;
    }

    public PDFTableColumn setBorderLeft(PDFTableBorder borderLeft) {
        if (borderLeft == null) {
            throw new IllegalArgumentException("null is not allowed here");
        }
        this.borderLeft = borderLeft;
        return this;
    }

    public PDFTableBorder getBorderRight() {
        return this.borderRight;
    }

    public PDFTableColumn setBorderRight(PDFTableBorder borderRight) {
        if (borderRight == null) {
            throw new IllegalArgumentException("null is not allowed here");
        }
        this.borderRight = borderRight;
        return this;
    }

    public PDFTableBorder getBorderTop() {
        return this.borderTop;
    }

    public PDFTableColumn setBorderTop(PDFTableBorder borderTop) {
        if (borderTop == null) {
            throw new IllegalArgumentException("null is not allowed here");
        }
        this.borderTop = borderTop;
        return this;
    }

    public PDFTableBorder getBorderBottom() {
        return this.borderBottom;
    }

    public PDFTableColumn setBorderBottom(PDFTableBorder borderBottom) {
        if (borderBottom == null) {
            throw new IllegalArgumentException("null is not allowed here");
        }
        this.borderBottom = borderBottom;
        return this;
    }

    public PDFTableColumn setBorder(PDFTableBorder border) {
        this.setBorderLeft(border);
        this.setBorderRight(border);
        this.setBorderTop(border);
        this.setBorderBottom(border);
        return this;
    }

    public PDFTableColumn setPadding(float padding) {
        this.setPaddingLeft(padding);
        this.setPaddingRight(padding);
        this.setPaddingTop(padding);
        this.setPaddingBottom(padding);
        return this;
    }

    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    public PDFTableColumn setPaddingLeft(float paddingLeft) {
        if (paddingLeft < 0.0f || paddingLeft + this.paddingRight >= this.width) {
            throw new IllegalArgumentException("Invalid value");
        }
        this.paddingLeft = paddingLeft;
        return this;
    }

    public float getPaddingRight() {
        return this.paddingRight;
    }

    public PDFTableColumn setPaddingRight(float paddingRight) {
        if (paddingRight < 0.0f || this.paddingLeft + paddingRight >= this.width) {
            throw new IllegalArgumentException("Invalid value");
        }
        this.paddingRight = paddingRight;
        return this;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public PDFTableColumn setPaddingTop(float paddingTop) {
        if (paddingTop < 0.0f) {
            throw new IllegalArgumentException("Invalid value");
        }
        this.paddingTop = paddingTop;
        return this;
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    public PDFTableColumn setPaddingBottom(float paddingBottom) {
        if (paddingBottom < 0.0f) {
            throw new IllegalArgumentException("Invalid value");
        }
        this.paddingBottom = paddingBottom;
        return this;
    }

    public float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    public PDFTableColumn setLineSpacingFactor(float lineSpacingFactor) {
        if (lineSpacingFactor < 0.0f) {
            throw new IllegalArgumentException("Invalid value");
        }
        this.lineSpacingFactor = lineSpacingFactor;
        return this;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public PDFTableColumn setFontColor(Color fontColor) {
        if (fontColor == null) {
            throw new IllegalArgumentException("null value not allowed");
        }
        this.fontColor = fontColor;
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public PDFTableColumn setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public Boolean getUnderline() {
        return this.underline;
    }

    public PDFTableColumn setUnderline(Boolean underline) {
        this.underline = underline;
        return this;
    }
}

