/*
 * Decompiled with CFR 0.152.
 */
package com.moebiusgames.pdfbox.table;

import com.moebiusgames.pdfbox.table.PDFPageWithStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class PDFRenderContext {
    private final PDDocument document;
    private final List<PDFPageWithStream> pages = new ArrayList<PDFPageWithStream>();

    public PDFRenderContext(PDDocument document, PDPage firstPage) {
        this.document = document;
        this.pages.add(new PDFPageWithStream(document, firstPage));
        document.addPage(firstPage);
    }

    public PDFPageWithStream getLastPage() {
        if (this.pages.isEmpty()) {
            throw new IllegalStateException("no pages");
        }
        return this.pages.get(this.pages.size() - 1);
    }

    public PDFPageWithStream getPage(int index) {
        if (index < 0 || index >= this.pages.size()) {
            throw new IllegalArgumentException("Page index " + index + " is out of range");
        }
        return this.pages.get(index);
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public List<PDFPageWithStream> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public PDFPageWithStream getOrCreateNextPage(PDFPageWithStream currentPage) {
        int index = this.pages.indexOf(currentPage);
        if (index < 0) {
            throw new IllegalArgumentException("Not a page of this context");
        }
        if (index == this.pages.size() - 1) {
            return this.addPage();
        }
        return this.pages.get(index + 1);
    }

    public PDFPageWithStream addPage() {
        PDFPageWithStream lastPage = this.getLastPage();
        PDPage newPdPage = new PDPage(lastPage.getPage().getMediaBox());
        PDFPageWithStream newPage = new PDFPageWithStream(this.document, newPdPage);
        this.pages.add(newPage);
        this.document.addPage(newPdPage);
        return newPage;
    }

    public void closeAllPages() throws IOException {
        for (PDFPageWithStream page : this.pages) {
            page.close();
        }
    }
}

