/*
 * Decompiled with CFR 0.152.
 */
package com.moebiusgames.pdfbox.table;

import com.moebiusgames.pdfbox.table.Utils;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

enum BulletPoint {
    CIRCLE((stream, x, y, size) -> {
        Utils.drawCircle(stream, x, y, size / 2.0f);
        stream.fill();
    }),
    CIRCLE_HOLLOW((stream, x, y, size) -> {
        Utils.drawCircle(stream, x, y, size / 2.0f);
        stream.stroke();
    }),
    RECTANGLE((stream, x, y, size) -> {
        stream.addRect(x - size / 2.0f, y - size / 2.0f, size, size);
        stream.fill();
    });

    private final DrawFunction drawFunction;

    private BulletPoint(DrawFunction drawFunction) {
        this.drawFunction = drawFunction;
    }

    public void draw(PDPageContentStream stream, float x, float y, float size) throws IOException {
        this.drawFunction.draw(stream, x, y, size);
    }

    public static BulletPoint getForIndent(int indent) {
        indent = Math.min(BulletPoint.values().length - 1, indent - 1);
        return BulletPoint.values()[indent];
    }

    static interface DrawFunction {
        public void draw(PDPageContentStream var1, float var2, float var3, float var4) throws IOException;
    }
}

