/*
 * Decompiled with CFR 0.152.
 */
package com.moebiusgames.pdfbox.table;

import com.moebiusgames.pdfbox.table.PDFTable;
import com.moebiusgames.pdfbox.table.PDFTableCell;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PDFTableRow {
    private final int index;
    final List<PDFTableCell> cells = new ArrayList<PDFTableCell>();
    private float minHeight = 0.0f;
    private final PDFTable table;

    PDFTableRow(PDFTable table, int index) {
        this.table = table;
        this.index = index;
        for (int i = 0; i < table.getColumns(); ++i) {
            this.cells.add(new PDFTableCell(this, i, table));
        }
    }

    public int getIndex() {
        return this.index;
    }

    public float getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(float minHeight) {
        this.minHeight = minHeight;
    }

    public PDFTableCell getCell(int index) {
        if (index < 0 || index >= this.cells.size()) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.cells.get(index);
    }

    public float getMaxHeight() throws IOException {
        float maxHeight = 0.0f;
        for (int colIndex = 0; colIndex < this.cells.size(); ++colIndex) {
            PDFTableCell col = this.cells.get(colIndex);
            if (col == null) continue;
            col.updateContentLayout();
            maxHeight = Math.max(maxHeight, col.getHeight());
        }
        return Math.max(this.minHeight, maxHeight);
    }
}

