/*
 * Decompiled with CFR 0.152.
 */
package com.moebiusgames.pdfbox.table;

import com.moebiusgames.pdfbox.table.Align;
import com.moebiusgames.pdfbox.table.BulletPoint;
import com.moebiusgames.pdfbox.table.PDFTable;
import com.moebiusgames.pdfbox.table.PDFTableBorder;
import com.moebiusgames.pdfbox.table.PDFTableRow;
import com.moebiusgames.pdfbox.table.PDFUtils;
import com.moebiusgames.pdfbox.table.TextType;
import com.moebiusgames.pdfbox.table.Utils;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;

public class PDFTableCell {
    private static final float INDENT_WIDTH = 28.346458f;
    private final PDFTableRow row;
    private final int index;
    private int size = 1;
    private int fontSize = PDFTable.NOT_SET;
    private PDFont font = null;
    private Align align = null;
    private String content = "";
    private TextType textType = TextType.PLAIN;
    private LaidoutContent laidoutContent = null;
    private PDFTableBorder borderLeft;
    private PDFTableBorder borderRight;
    private PDFTableBorder borderTop;
    private PDFTableBorder borderBottom;
    private float paddingLeft = PDFTable.NOT_SET;
    private float paddingRight = PDFTable.NOT_SET;
    private float paddingTop = PDFTable.NOT_SET;
    private float paddingBottom = PDFTable.NOT_SET;
    private Color fontColor = PDFTable.NOT_SET_COLOR;
    private Color backgroundColor = PDFTable.NOT_SET_COLOR;
    private float lineSpacingFactor = PDFTable.NOT_SET;
    private final PDFTable table;

    PDFTableCell(PDFTableRow row, int cellIndex, PDFTable table) {
        this.table = table;
        this.row = row;
        this.index = cellIndex;
    }

    public PDFTableCell setContent(String content) {
        this.content = content;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public PDFont getFont() {
        if (!this.hasFont()) {
            return this.table.getColumn(this.index).getFont();
        }
        return this.font;
    }

    public int getFontSize() {
        if (!this.hasFontSize()) {
            return this.table.getColumn(this.index).getFontSize();
        }
        return this.fontSize;
    }

    public Align getAlign() {
        return this.align;
    }

    public PDFTableCell setAlign(Align align) {
        this.align = align;
        return this;
    }

    public boolean hasAlign() {
        return this.align != null;
    }

    public TextType getTextType() {
        return this.textType;
    }

    public PDFTableCell setTextType(TextType textType) {
        this.textType = textType;
        return this;
    }

    public PDFTableCell setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public PDFTableCell setFontSize(int fontSize) {
        if (fontSize <= 0 && fontSize != PDFTable.NOT_SET) {
            throw new IllegalArgumentException("font size must be positive");
        }
        this.fontSize = fontSize;
        return this;
    }

    public boolean hasFont() {
        return this.font != null;
    }

    public boolean hasFontSize() {
        return this.fontSize != PDFTable.NOT_SET;
    }

    public int getSize() {
        return this.size;
    }

    public PDFTableBorder getBorderLeft() {
        return this.borderLeft == null ? this.table.getColumn(this.index).getBorderLeft() : this.borderLeft;
    }

    public boolean hasBorderLeft() {
        return this.borderLeft != null;
    }

    public PDFTableCell setBorderLeft(PDFTableBorder borderLeft) {
        this.borderLeft = borderLeft;
        return this;
    }

    public PDFTableBorder getBorderRight() {
        return this.borderRight == null ? this.table.getColumn(this.index).getBorderRight() : this.borderRight;
    }

    public boolean hasBorderRight() {
        return this.borderRight != null;
    }

    public PDFTableCell setBorderRight(PDFTableBorder borderRight) {
        this.borderRight = borderRight;
        return this;
    }

    public PDFTableBorder getBorderTop() {
        return this.borderTop == null ? this.table.getColumn(this.index).getBorderTop() : this.borderTop;
    }

    public boolean hasBorderTop() {
        return this.borderTop != null;
    }

    public PDFTableCell setBorderTop(PDFTableBorder borderTop) {
        this.borderTop = borderTop;
        return this;
    }

    public PDFTableBorder getBorderBottom() {
        return this.borderBottom == null ? this.table.getColumn(this.index).getBorderBottom() : this.borderBottom;
    }

    public boolean hasBorderBottom() {
        return this.borderLeft != null;
    }

    public PDFTableCell setBorderBottom(PDFTableBorder borderBottom) {
        this.borderBottom = borderBottom;
        return this;
    }

    public PDFTableCell setPadding(float padding) {
        this.setPaddingLeft(padding);
        this.setPaddingRight(padding);
        this.setPaddingTop(padding);
        this.setPaddingBottom(padding);
        return this;
    }

    public float getPaddingLeft() {
        return this.paddingLeft == (float)PDFTable.NOT_SET ? this.table.getColumn(this.index).getPaddingLeft() : this.paddingLeft;
    }

    public PDFTableCell setPaddingLeft(float paddingLeft) {
        if (paddingLeft < 0.0f && paddingLeft != (float)PDFTable.NOT_SET || paddingLeft + this.paddingRight >= this.getWidth()) {
            throw new IllegalArgumentException("invalid value");
        }
        this.paddingLeft = paddingLeft;
        return this;
    }

    public float getPaddingRight() {
        return this.paddingRight == (float)PDFTable.NOT_SET ? this.table.getColumn(this.index).getPaddingRight() : this.paddingRight;
    }

    public PDFTableCell setPaddingRight(float paddingRight) {
        if (paddingRight < 0.0f && paddingRight != (float)PDFTable.NOT_SET || this.paddingLeft + paddingRight >= this.getWidth()) {
            throw new IllegalArgumentException("invalid value");
        }
        this.paddingRight = paddingRight;
        return this;
    }

    public float getPaddingTop() {
        return this.paddingTop == (float)PDFTable.NOT_SET ? this.table.getColumn(this.index).getPaddingTop() : this.paddingTop;
    }

    public PDFTableCell setPaddingTop(float paddingTop) {
        if (paddingTop < 0.0f && paddingTop != (float)PDFTable.NOT_SET) {
            throw new IllegalArgumentException("invalid value");
        }
        this.paddingTop = paddingTop;
        return this;
    }

    public float getPaddingBottom() {
        return this.paddingBottom == (float)PDFTable.NOT_SET ? this.table.getColumn(this.index).getPaddingBottom() : this.paddingBottom;
    }

    public PDFTableCell setPaddingBottom(float paddingBottom) {
        if (paddingBottom < 0.0f && paddingBottom != (float)PDFTable.NOT_SET) {
            throw new IllegalArgumentException("invalid value");
        }
        this.paddingBottom = paddingBottom;
        return this;
    }

    public float getLineSpacingFactor() {
        return this.lineSpacingFactor == (float)PDFTable.NOT_SET ? this.table.getColumn(this.index).getLineSpacingFactor() : this.lineSpacingFactor;
    }

    public PDFTableCell setLineSpacingFactor(float lineSpacingFactor) {
        if (lineSpacingFactor < 0.0f && lineSpacingFactor != (float)PDFTable.NOT_SET) {
            throw new IllegalArgumentException("invalid value");
        }
        this.lineSpacingFactor = lineSpacingFactor;
        return this;
    }

    public Color getFontColor() {
        return this.fontColor == PDFTable.NOT_SET_COLOR ? this.table.getColumn(this.index).getFontColor() : this.fontColor;
    }

    public PDFTableCell setFontColor(Color fontColor) {
        if (this.fontColor == null) {
            throw new IllegalArgumentException("null value not allowed");
        }
        this.fontColor = fontColor;
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor == PDFTable.NOT_SET_COLOR ? this.table.getColumn(this.index).getBackgroundColor() : this.backgroundColor;
    }

    public PDFTableCell setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public float getWidth() {
        float total = 0.0f;
        for (int i = this.index; i < this.index + this.size; ++i) {
            total += this.table.getColumn(i).getWidth();
        }
        return total;
    }

    public float getWidth(int n) {
        if (n < 0 || n >= this.getSize()) {
            throw new IllegalArgumentException("n mus be between 0 and " + (this.getSize() - 1));
        }
        return this.table.getColumn(this.index + n).getWidth();
    }

    public float getTextSpaceWidth() {
        return this.getWidth() - (this.getPaddingLeft() + this.getPaddingRight());
    }

    public void merge(int n) {
        PDFTableCell cell;
        int i;
        if (n <= 0 || this.index + n >= this.row.cells.size()) {
            throw new IllegalArgumentException("invalid n");
        }
        for (i = this.index + 1; i <= this.index + n; ++i) {
            this.row.cells.set(i, null);
        }
        for (i = this.index + n + 1; i < this.row.cells.size() && (cell = this.row.cells.get(i)) == null; ++i) {
            this.row.cells.set(i, new PDFTableCell(this.row, i, this.table));
        }
        this.size = n + 1;
    }

    float getMinRequiredHeight() throws IOException {
        if (this.laidoutContent == null) {
            throw new IllegalStateException("No layout found in col");
        }
        return this.laidoutContent.getHeight() + this.getPaddingBottom() + this.getPaddingTop();
    }

    float getHeight() throws IOException {
        if (this.laidoutContent == null) {
            throw new IllegalStateException("No layout found in col");
        }
        return this.laidoutContent.getHeight();
    }

    void updateContentLayout() {
        switch (this.textType) {
            case PLAIN: {
                this.laidoutContent = this.layoutPlainContent(this.content);
                break;
            }
            case HTML: {
                this.laidoutContent = this.layoutHTMLContent(this.content);
            }
        }
    }

    LaidoutContent getLaidoutContent() {
        return this.laidoutContent;
    }

    private LaidoutContent layoutPlainContent(String aContent) {
        LaidoutContent aLaidoutContent = new LaidoutContent();
        this.plainContentToBlocks(aContent, aLaidoutContent);
        return aLaidoutContent;
    }

    private LaidoutContent layoutHTMLContent(String aContent) {
        Document document = Jsoup.parse((String)aContent);
        LaidoutContent newLaidoutContent = new LaidoutContent();
        this.traverseHTMLLayout(newLaidoutContent, new Pos(), new LayoutFrame(), new NewLineLayout(), null, (Node)document.body());
        newLaidoutContent.trim();
        return newLaidoutContent;
    }

    private void traverseHTMLLayout(LaidoutContent laidoutContent, Pos xPos, LayoutFrame inFrame, NewLineLayout newLineLayout, Node predecessorNode, Node node) {
        LayoutFrame frame = new LayoutFrame(inFrame);
        if (predecessorNode != null) {
            switch (predecessorNode.nodeName().toLowerCase()) {
                case "ul": 
                case "blockquote": {
                    if (frame.indent != 0) break;
                    newLineLayout.newLines++;
                }
            }
        }
        switch (node.nodeName().toLowerCase()) {
            case "div": {
                newLineLayout.setConditionalNewLine(1);
                break;
            }
            case "br": {
                this.applyNewLineLayout(newLineLayout, laidoutContent, xPos, frame);
                laidoutContent.addRow(frame);
                xPos.pos = 0.0f;
                break;
            }
            case "blockquote": {
                if (frame.indent == 0) {
                    newLineLayout.setConditionalNewLine(2);
                }
                frame.indent++;
                break;
            }
            case "b": {
                frame.bold = true;
                break;
            }
            case "i": {
                frame.italic = true;
                break;
            }
            case "font": {
                if (node.hasAttr("size")) {
                    try {
                        frame.htmlSize = Integer.valueOf(node.attr("size"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!node.hasAttr("color")) break;
                frame.color = Utils.htmlColorToColor(node.attr("color"));
                break;
            }
            case "ul": {
                newLineLayout.setConditionalNewLine(frame.indent == 0 ? 2 : 1);
                frame.indent++;
                break;
            }
            case "li": {
                frame.bulletPoint = true;
                newLineLayout.setConditionalNewLine(1);
            }
        }
        if (node.nodeName().equals("#text")) {
            this.htmlContentToBlocks(this.htmlToText(node.outerHtml()), laidoutContent, xPos, frame, newLineLayout);
        }
        List childNodes = node.childNodesCopy();
        for (int i = 0; i < childNodes.size(); ++i) {
            Node aNode = (Node)childNodes.get(i);
            Node aPredecessorNode = i > 0 ? (Node)childNodes.get(i - 1) : null;
            this.traverseHTMLLayout(laidoutContent, xPos, frame, newLineLayout, aPredecessorNode, aNode);
        }
    }

    private void plainContentToBlocks(String aContent, LaidoutContent laidoutContent) {
        String cleanedContent = this.filterPDFContent(aContent.replace("\n", " \n ").replace("\\s+", " "));
        LinkedList<String> words = new LinkedList<String>(Arrays.asList(cleanedContent.split("[ ]+")));
        this.contentToBlocks(words, laidoutContent, new Pos(), new LayoutFrame(), new NewLineLayout());
    }

    private void htmlContentToBlocks(String aContent, LaidoutContent laidoutContent, Pos xPos, LayoutFrame frame, NewLineLayout newLineLayout) {
        String cleanedContent = aContent.replace("\n", " ").replace("\\s+", " ");
        LinkedList<String> words = new LinkedList<String>(Arrays.asList(cleanedContent.split("[ ]+")));
        if (cleanedContent.endsWith(" ")) {
            words.add("");
        }
        this.contentToBlocks(words, laidoutContent, xPos, frame, newLineLayout);
    }

    private void contentToBlocks(List<String> words, LaidoutContent laidoutContent, Pos xPos, LayoutFrame frame, NewLineLayout newLineLayout) {
        this.applyNewLineLayout(newLineLayout, laidoutContent, xPos, frame);
        if (xPos.pos == 0.0f) {
            float indent = 28.346458f * (float)frame.indent;
            xPos.pos += indent;
        }
        float textSpaceWidth = this.getTextSpaceWidth() - xPos.pos;
        while (!words.isEmpty()) {
            String line;
            StringBuilder contentBuilder = new StringBuilder();
            LaidoutContentBlock block = new LaidoutContentBlock(frame);
            frame.bulletPoint = false;
            String lastWord = null;
            while (block.getWidth() <= textSpaceWidth && !words.isEmpty()) {
                if (lastWord != null) {
                    contentBuilder.append(" ");
                }
                if ((lastWord = words.remove(0)).equals("\n")) break;
                contentBuilder.append(lastWord);
                block.setContent(contentBuilder.toString());
            }
            float textSize = block.getWidth();
            boolean newLine = false;
            xPos.pos += textSize;
            if (textSize > textSpaceWidth && lastWord != null && !lastWord.equals("\n")) {
                words.add(0, lastWord);
                contentBuilder.delete(contentBuilder.length() - lastWord.length(), contentBuilder.length());
                newLine = true;
            }
            if (lastWord != null && lastWord.equals("\n")) {
                newLine = true;
            }
            if (!(!(line = contentBuilder.toString()).trim().isEmpty() || lastWord != null && lastWord.equals("\n") || words.isEmpty() || textSpaceWidth != this.getTextSpaceWidth())) {
                String problematicWord = words.remove(0);
                if (problematicWord.length() <= 1) {
                    line = problematicWord;
                } else {
                    words.add(0, problematicWord.substring(problematicWord.length() / 2));
                    words.add(0, problematicWord.substring(0, problematicWord.length() / 2));
                    continue;
                }
            }
            LaidoutContentRow aRow = laidoutContent.getCurrentRow();
            block.setContent(line);
            aRow.addBlock(block);
            if (newLine) {
                laidoutContent.addRow();
                xPos.pos = 28.346458f * (float)frame.indent;
            }
            textSpaceWidth = this.getTextSpaceWidth() - xPos.pos;
        }
    }

    private void applyNewLineLayout(NewLineLayout newLineLayout, LaidoutContent laidoutContent, Pos xPos, LayoutFrame frame) {
        while (newLineLayout.newLines > 0) {
            if (newLineLayout.newLines > 0) {
                newLineLayout.newLines--;
            } else {
                newLineLayout.conditionalNewlines--;
            }
            xPos.pos = 0.0f;
            laidoutContent.addRow(frame);
        }
        if (newLineLayout.conditionalNewlines > 0) {
            int i;
            int emptyLines = 0;
            if (laidoutContent.getNumRows() >= newLineLayout.conditionalNewlines) {
                for (i = 1; i <= newLineLayout.conditionalNewlines; ++i) {
                    if (!((LaidoutContentRow)laidoutContent.rows.get(laidoutContent.getNumRows() - i)).isEmpty()) continue;
                    ++emptyLines;
                }
            }
            if (emptyLines < newLineLayout.conditionalNewlines) {
                for (i = 0; i < newLineLayout.conditionalNewlines - emptyLines; ++i) {
                    xPos.pos = 0.0f;
                    laidoutContent.addRow(frame);
                }
            }
            xPos.pos = 0.0f;
        }
        newLineLayout.conditionalNewlines = 0;
    }

    void render(PDPageContentStream stream, float x, float y, int laidOutRowIndexFrom, int laidOutRowIndexTo, float rowHeight, boolean pageBreakBefore) throws IOException {
        this.renderBackground(stream, x, y, rowHeight);
        this.renderBorders(stream, x, y, rowHeight, pageBreakBefore);
        this.renderText(stream, x, y, laidOutRowIndexFrom, laidOutRowIndexTo);
    }

    private void renderBackground(PDPageContentStream stream, float x, float y, float rowHeight) throws IOException {
        Color colorBackground = this.getBackgroundColor();
        if (colorBackground != null && colorBackground.getAlpha() > 0) {
            stream.setNonStrokingColor(colorBackground);
            stream.setLineWidth(0.0f);
            stream.addRect(x + this.getBorderLeft().getLineWidth() / 2.0f, y - rowHeight + this.getBorderBottom().getLineWidth() / 2.0f, this.getWidth() - (this.getBorderLeft().getLineWidth() + this.getBorderRight().getLineWidth()) / 2.0f, rowHeight - (this.getBorderBottom().getLineWidth() + this.getBorderTop().getLineWidth()) / 2.0f);
            stream.fill();
        }
    }

    private void renderBorders(PDPageContentStream stream, float x, float y, float rowHeight, boolean pageBreakBefore) throws IOException {
        if (this.row.getIndex() == 0 || pageBreakBefore) {
            this.getBorderTop().render(stream, x, y, x + this.getWidth(), y);
        }
        if (this.index == 0) {
            this.getBorderLeft().render(stream, x, y - rowHeight, x, y);
        }
        PDFTableBorder rightBorder = this.getBorderRight();
        if (!this.hasBorderRight() && this.index + 1 < this.row.cells.size() && this.row.getCell(this.index + 1) != null && this.row.getCell(this.index + 1).hasBorderLeft()) {
            rightBorder = this.row.getCell(this.index + 1).getBorderLeft();
        }
        rightBorder.render(stream, x + this.getWidth(), y - rowHeight, x + this.getWidth(), y);
        float lastWidth = x;
        for (int i = 0; i < this.getSize(); ++i) {
            PDFTableBorder bottomBorder = this.getBorderBottom();
            if (!this.hasBorderBottom() && this.row.getIndex() + 1 < this.table.getRows()) {
                int bottomRowColIndex;
                PDFTableRow bottomRow = this.table.getRow(this.row.getIndex() + 1);
                for (bottomRowColIndex = this.index; bottomRow.getCell(bottomRowColIndex) == null && bottomRowColIndex > 0; --bottomRowColIndex) {
                }
                if (bottomRow.getCell(bottomRowColIndex) != null) {
                    bottomBorder = bottomRow.getCell(bottomRowColIndex).getBorderTop();
                }
            }
            bottomBorder.render(stream, lastWidth, y - rowHeight, lastWidth + this.getWidth(i), y - rowHeight);
            lastWidth += this.getWidth(i);
        }
    }

    private void renderText(PDPageContentStream stream, float x, float y, int laidOutRowIndexFrom, int laidOutRowIndexTo) throws IOException {
        Align currentAlign;
        Align align = currentAlign = this.align == null ? this.table.getColumn(this.index).getAlign() : this.align;
        if (this.getTextType() == TextType.HTML && currentAlign == Align.RIGHT) {
            throw new UnsupportedOperationException("Can't use align right with HTML content");
        }
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        for (int rowIdx = laidOutRowIndexFrom; rowIdx < laidOutRowIndexTo; ++rowIdx) {
            LaidoutContentRow aRow = this.laidoutContent.getRow(rowIdx);
            float rowShiftX = currentAlign == Align.RIGHT ? this.getTextSpaceWidth() - aRow.getWidth() : 0.0f;
            float yOffsetHalf = (aRow.getMaxHeight() - aRow.getMaxFontCapHeight()) / 2.0f;
            offsetY -= aRow.getMaxFontCapHeight() + yOffsetHalf;
            for (int i = 0; i < aRow.getBlocks().size(); ++i) {
                LaidoutContentBlock block = aRow.getBlocks().get(i);
                if (i == 0) {
                    offsetX = currentAlign == Align.LEFT ? (offsetX += (float)block.getIndent() * 28.346458f) : (offsetX -= (float)block.getIndent() * 28.346458f);
                    if (block.isBulletPoint()) {
                        float bulletSize = block.getFontCapHeight() * 0.7f;
                        float bulletY = y - this.getPaddingTop() + offsetY + block.getFontCapHeight() / 2.0f;
                        float bulletX = x + this.getPaddingLeft() + offsetX + rowShiftX - (bulletSize / 2.0f + 2.8346457f);
                        stream.setNonStrokingColor(Color.BLACK);
                        stream.setStrokingColor(Color.BLACK);
                        BulletPoint.getForIndent(block.getIndent()).draw(stream, bulletX, bulletY, bulletSize);
                    }
                }
                stream.setNonStrokingColor(block.getFontColor());
                stream.setFont(block.getFont(), (float)block.getFontSize());
                float leading = Utils.getFontHeight(block.getFont(), block.getFontSize()) * (1.0f + this.getLineSpacingFactor());
                stream.beginText();
                stream.newLineAtOffset(x + this.getPaddingLeft() + offsetX + rowShiftX, y - this.getPaddingTop() + offsetY);
                stream.setLeading(leading);
                stream.showText(block.getContent());
                stream.endText();
                offsetX += block.getWidth();
            }
            offsetX = 0.0f;
            offsetY += aRow.getMaxFontCapHeight() + yOffsetHalf;
            offsetY -= aRow.getMaxHeight();
        }
    }

    private String htmlToText(String html) {
        StringBuilder sb = new StringBuilder();
        sb.append(Jsoup.parse((String)html).text());
        if (!html.isEmpty()) {
            int i;
            for (i = 0; i < html.length() && html.charAt(i) == ' '; ++i) {
                sb.insert(0, ' ');
            }
            for (i = html.length() - 1; i >= 0 && html.charAt(i) == ' '; --i) {
                sb.append(' ');
            }
        }
        return this.filterPDFContent(sb.toString());
    }

    private String filterPDFContent(String content) {
        PDFont currentFont = this.getFont();
        if (currentFont instanceof PDSimpleFont) {
            StringBuilder sb = new StringBuilder();
            PDSimpleFont simpleFont = (PDSimpleFont)currentFont;
            for (char c : content.toCharArray()) {
                String name = simpleFont.getGlyphList().codePointToName((int)c);
                if (!simpleFont.getEncoding().contains(name)) continue;
                sb.append(c);
            }
            return sb.toString();
        }
        return content;
    }

    class LaidoutContent {
        private final List<LaidoutContentRow> rows = new ArrayList<LaidoutContentRow>();

        public LaidoutContent() {
            this.rows.add(new LaidoutContentRow());
        }

        public LaidoutContentRow getCurrentRow() {
            return this.rows.get(this.rows.size() - 1);
        }

        public void addRow() {
            this.rows.add(new LaidoutContentRow());
        }

        public void addRow(LayoutFrame frame) {
            LaidoutContentRow laidoutContentRow = new LaidoutContentRow();
            laidoutContentRow.addBlock(new LaidoutContentBlock(frame));
            this.rows.add(laidoutContentRow);
        }

        public float getHeight() {
            return this.rows.stream().map(row -> Float.valueOf(row.getMaxHeight())).reduce((h1, h2) -> Float.valueOf(h1.floatValue() + h2.floatValue())).orElse(Float.valueOf(0.0f)).floatValue();
        }

        public float getHeight(int startRow, int endRow) {
            float result = 0.0f;
            for (int i = startRow; i < endRow; ++i) {
                result += this.rows.get(i).getMaxHeight();
            }
            return result;
        }

        private LaidoutContentRow getRow(int idx) {
            return this.rows.get(idx);
        }

        int getNumRows() {
            return this.rows.size();
        }

        private void trim() {
            this.rows.forEach(row -> ((LaidoutContentRow)row).trim());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Content {\n");
            this.rows.forEach(row -> sb.append("\t").append(row.toString()).append("\n"));
            sb.append("}\n");
            return sb.toString();
        }
    }

    private static class Pos {
        private float pos;

        private Pos() {
        }
    }

    private static class LayoutFrame {
        private int indent = 0;
        private boolean bulletPoint = false;
        private Color color = null;
        private Integer htmlSize = null;
        private Boolean bold = null;
        private Boolean italic = null;

        public LayoutFrame() {
        }

        public LayoutFrame(LayoutFrame frame) {
            this.indent = frame.indent;
            this.bulletPoint = frame.bulletPoint;
            this.color = frame.color;
            this.htmlSize = frame.htmlSize;
            this.bold = frame.bold;
            this.italic = frame.italic;
        }
    }

    private static class NewLineLayout {
        private int newLines = 0;
        private int conditionalNewlines = 0;

        private NewLineLayout() {
        }

        private void setConditionalNewLine(int amount) {
            this.conditionalNewlines = Math.max(this.conditionalNewlines, amount);
        }
    }

    class LaidoutContentBlock {
        private String content = "";
        private boolean bulletPoint = false;
        private PDFont font = null;
        private Integer fontSize = null;
        private Color fontColor = null;
        private int indent = 0;

        public LaidoutContentBlock(LayoutFrame fromFrame) {
            this.indent = fromFrame.indent;
            this.bulletPoint = fromFrame.bulletPoint;
            if (fromFrame.bold != null || fromFrame.italic != null) {
                HashSet<PDFUtils.FontModifier> modifiers = new HashSet<PDFUtils.FontModifier>();
                if (fromFrame.bold != null && fromFrame.bold.booleanValue()) {
                    modifiers.add(PDFUtils.FontModifier.BOLD);
                }
                if (fromFrame.italic != null && fromFrame.italic.booleanValue()) {
                    modifiers.add(PDFUtils.FontModifier.ITALIC);
                }
                this.font = PDFUtils.modifyFont(this.getFont(), modifiers);
            }
            this.fontColor = fromFrame.color;
            if (fromFrame.htmlSize != null) {
                this.fontSize = Math.max(1, PDFTableCell.this.getFontSize() + (fromFrame.htmlSize - 4) * 2);
            }
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public void setFont(PDFont font) {
            this.font = font;
        }

        public void setFontSize(Integer fontSize) {
            this.fontSize = fontSize;
        }

        public void setFontColor(Color fontColor) {
            this.fontColor = fontColor;
        }

        public PDFont getFont() {
            return this.font == null ? PDFTableCell.this.getFont() : this.font;
        }

        public int getFontSize() {
            return this.fontSize == null ? PDFTableCell.this.getFontSize() : this.fontSize.intValue();
        }

        public Color getFontColor() {
            return this.fontColor == null ? PDFTableCell.this.getFontColor() : this.fontColor;
        }

        public int getIndent() {
            return this.indent;
        }

        public boolean isBulletPoint() {
            return this.bulletPoint;
        }

        public float getHeight() {
            return this.getFontHeight() * (1.0f + PDFTableCell.this.getLineSpacingFactor());
        }

        public float getFontHeight() {
            return Utils.getFontHeight(this.getFont(), this.getFontSize());
        }

        public float getFontCapHeight() {
            return this.getFont().getFontDescriptor().getCapHeight() / 1000.0f * (float)this.getFontSize();
        }

        public float getWidth() {
            return this.getWidth(this.getContent());
        }

        public float getWidth(String text) {
            return Utils.measureTextSize(this.getFont(), this.getFontSize(), text);
        }

        public String toString() {
            return "[" + this.content + "]";
        }
    }

    class LaidoutContentRow {
        private final List<LaidoutContentBlock> blocks = new ArrayList<LaidoutContentBlock>();

        LaidoutContentRow() {
        }

        public void addBlock(LaidoutContentBlock block) {
            this.blocks.add(block);
        }

        public LaidoutContentBlock getLastBlock() {
            if (this.blocks.isEmpty()) {
                return null;
            }
            return this.blocks.get(this.blocks.size() - 1);
        }

        public List<LaidoutContentBlock> getBlocks() {
            return this.blocks;
        }

        public boolean isEmpty() {
            return this.blocks.isEmpty() || this.blocks.stream().allMatch(block -> block.getContent().isEmpty());
        }

        public float getMaxHeight() {
            return this.blocks.stream().map(LaidoutContentBlock::getHeight).max(Float::compare).orElse(Float.valueOf(0.0f)).floatValue();
        }

        public float getMaxFontHeight() {
            return this.blocks.stream().map(LaidoutContentBlock::getFontHeight).max(Float::compare).orElse(Float.valueOf(0.0f)).floatValue();
        }

        public float getMaxFontCapHeight() {
            return this.blocks.stream().map(LaidoutContentBlock::getFontCapHeight).max(Float::compare).orElse(Float.valueOf(0.0f)).floatValue();
        }

        public float getWidth() {
            return this.blocks.stream().map(LaidoutContentBlock::getWidth).reduce((f1, f2) -> Float.valueOf(f1.floatValue() + f2.floatValue())).orElse(Float.valueOf(0.0f)).floatValue();
        }

        private void trim() {
            while (this.blocks.size() > 1 && this.blocks.get(this.blocks.size() - 1).getContent().trim().isEmpty()) {
                this.blocks.remove(this.blocks.size() - 1);
            }
            while (this.blocks.size() > 1 && this.blocks.get(0).getContent().isEmpty()) {
                this.blocks.remove(0);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.blocks.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                LaidoutContentBlock block = this.blocks.get(i);
                sb.append(block.toString());
            }
            return sb.toString();
        }
    }
}

