/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.maven.plugins.hibernate5ddl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.Converter;
import javax.persistence.Entity;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

final class EntityFinder {
    private static final Set<String> PACKAGE_LEVEL_ANNOTATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.hibernate.annotations.AnyMetaDef", "org.hibernate.annotations.AnyMetaDefs", "org.hibernate.annotations.FetchProfile", "org.hibernate.annotations.FetchProfile.FetchOverride", "org.hibernate.annotations.FetchProfiles", "org.hibernate.annotations.FilterDef", "org.hibernate.annotations.FilterDefs", "org.hibernate.annotations.GenericGenerator", "org.hibernate.annotations.GenericGenerators", "org.hibernate.annotations.NamedNativeQueries", "org.hibernate.annotations.NamedNativeQuery", "org.hibernate.annotations.NamedQueries", "org.hibernate.annotations.NamedQuery", "org.hibernate.annotations.TypeDef", "org.hibernate.annotations.TypeDefs")));
    private final transient Reflections reflections;
    private final ClassLoader classLoader;

    private EntityFinder(Reflections reflections, ClassLoader classLoader) {
        this.reflections = reflections;
        this.classLoader = classLoader;
    }

    public static EntityFinder forClassPath(MavenProject project, Log log, boolean includeTestClasses) throws MojoFailureException {
        Objects.requireNonNull(project, "Parameter project is null");
        ArrayList classPathElements = new ArrayList();
        try {
            classPathElements.addAll(project.getCompileClasspathElements());
            if (includeTestClasses) {
                classPathElements.addAll(project.getTestClasspathElements());
            }
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoFailureException("Failed to resolve project classpath.", (Throwable)ex);
        }
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        for (String classPathElem : classPathElements) {
            log.info((CharSequence)String.format("Adding classpath elemement '%s'...", classPathElem));
            classPathUrls.add(EntityFinder.classPathElemToUrl(classPathElem));
        }
        log.info((CharSequence)"Classpath URLs:");
        for (URL url : classPathUrls) {
            log.info((CharSequence)String.format("\t%s", url.toString()));
        }
        ClassLoader classLoader = AccessController.doPrivileged(new ClassLoaderCreator(classPathUrls));
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{classLoader})).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}));
        return new EntityFinder(reflections, classLoader);
    }

    public static EntityFinder forPackage(MavenProject project, Log log, String packageName, boolean includeTestClasses) throws MojoFailureException {
        ClassLoader classLoader;
        Reflections reflections;
        if (project == null) {
            reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{packageName})).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}));
            classLoader = reflections.getClass().getClassLoader();
        } else {
            ArrayList classPathElements = new ArrayList();
            try {
                classPathElements.addAll(project.getCompileClasspathElements());
                if (includeTestClasses) {
                    classPathElements.addAll(project.getTestClasspathElements());
                }
            }
            catch (DependencyResolutionRequiredException ex) {
                throw new MojoFailureException("Failed to resolve project classpath.", (Throwable)ex);
            }
            ArrayList<URL> classPathUrls = new ArrayList<URL>();
            for (String classPathElement : classPathElements) {
                log.info((CharSequence)String.format("Adding classpath elemement '%s'...", classPathElement));
                classPathUrls.add(EntityFinder.classPathElemToUrl(classPathElement));
            }
            log.info((CharSequence)"Classpath URLs:");
            for (URL url : classPathUrls) {
                log.info((CharSequence)String.format("\t%s", url.toString()));
            }
            classLoader = AccessController.doPrivileged(new ClassLoaderCreator(classPathUrls));
            reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[]{classLoader})).filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{packageName})).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}));
        }
        return new EntityFinder(reflections, classLoader);
    }

    public Set<Class<?>> findEntities() {
        HashSet entityClasses = new HashSet();
        Set classesWithEntity = this.reflections.getTypesAnnotatedWith(Entity.class);
        for (Class entityClass : classesWithEntity) {
            entityClasses.add(entityClass);
        }
        Set classesWithConverter = this.reflections.getTypesAnnotatedWith(Converter.class);
        for (Class entityClass : classesWithConverter) {
            entityClasses.add(entityClass);
        }
        return entityClasses;
    }

    public Set<Package> findPackages() {
        return Arrays.stream(this.classLoader.getDefinedPackages()).filter(aPackage -> PACKAGE_LEVEL_ANNOTATIONS.contains(aPackage.getClass().getName())).collect(Collectors.toSet());
    }

    private static URL classPathElemToUrl(String classPathElem) throws MojoFailureException {
        URL url;
        File file = new File(classPathElem);
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new MojoFailureException(String.format("Failed to convert classpath element '%s' to an URL.", classPathElem), (Throwable)ex);
        }
        return url;
    }

    private static class ClassLoaderCreator
    implements PrivilegedAction<ClassLoader> {
        private final transient List<URL> classPathUrls;

        public ClassLoaderCreator(List<URL> classPathUrls) {
            this.classPathUrls = classPathUrls;
        }

        @Override
        public ClassLoader run() {
            URLClassLoader classLoader = new URLClassLoader(this.classPathUrls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(classLoader);
            return classLoader;
        }
    }
}

