/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.extract.AbstractExtractor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class ZipExtractor
extends AbstractExtractor {
    @Override
    protected AbstractExtractor.ArchiveWrapper archiveStream(File source) throws FileNotFoundException, IOException {
        FileInputStream fin = new FileInputStream(source);
        BufferedInputStream in = new BufferedInputStream(fin);
        ZipArchiveInputStream zipIn = new ZipArchiveInputStream((InputStream)in);
        return new ZipArchiveWrapper(zipIn);
    }

    protected static class ZipArchiveWrapper
    implements AbstractExtractor.ArchiveWrapper {
        private final ZipArchiveInputStream _is;

        public ZipArchiveWrapper(ZipArchiveInputStream is) {
            this._is = is;
        }

        @Override
        public ArchiveEntry getNextEntry() throws IOException {
            return this._is.getNextZipEntry();
        }

        @Override
        public boolean canReadEntryData(ArchiveEntry entry) {
            return this._is.canReadEntryData(entry);
        }

        @Override
        public void close() throws IOException {
            this._is.close();
        }

        @Override
        public InputStream asStream() {
            return this._is;
        }
    }
}

