/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.commands;

import de.flapdoodle.embed.mongo.commands.MongoImportArguments;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableMongoImportArguments
extends MongoImportArguments {
    private final boolean verbose;
    private final String databaseName;
    private final String collectionName;
    private final String importFile;
    private final String type;
    private final boolean isHeaderline;
    private final boolean isJsonArray;
    private final boolean dropCollection;
    private final boolean upsertDocuments;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongoImportArguments(Builder builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.importFile = builder.importFile;
        if (builder.verboseIsSet()) {
            this.initShim.verbose(builder.verbose);
        }
        if (builder.typeIsSet()) {
            this.initShim.type(builder.type);
        }
        if (builder.isHeaderlineIsSet()) {
            this.initShim.isHeaderline(builder.isHeaderline);
        }
        if (builder.isJsonArrayIsSet()) {
            this.initShim.isJsonArray(builder.isJsonArray);
        }
        if (builder.dropCollectionIsSet()) {
            this.initShim.dropCollection(builder.dropCollection);
        }
        if (builder.upsertDocumentsIsSet()) {
            this.initShim.upsertDocuments(builder.upsertDocuments);
        }
        this.verbose = this.initShim.verbose();
        this.type = this.initShim.type();
        this.isHeaderline = this.initShim.isHeaderline();
        this.isJsonArray = this.initShim.isJsonArray();
        this.dropCollection = this.initShim.dropCollection();
        this.upsertDocuments = this.initShim.upsertDocuments();
        this.initShim = null;
    }

    private ImmutableMongoImportArguments(boolean verbose, String databaseName, String collectionName, String importFile, String type, boolean isHeaderline, boolean isJsonArray, boolean dropCollection, boolean upsertDocuments) {
        this.verbose = verbose;
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.importFile = importFile;
        this.type = type;
        this.isHeaderline = isHeaderline;
        this.isJsonArray = isJsonArray;
        this.dropCollection = dropCollection;
        this.upsertDocuments = upsertDocuments;
        this.initShim = null;
    }

    @Override
    public boolean verbose() {
        InitShim shim = this.initShim;
        return shim != null ? shim.verbose() : this.verbose;
    }

    @Override
    public Optional<String> databaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    @Override
    public Optional<String> collectionName() {
        return Optional.ofNullable(this.collectionName);
    }

    @Override
    public Optional<String> importFile() {
        return Optional.ofNullable(this.importFile);
    }

    @Override
    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    @Override
    public boolean isHeaderline() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isHeaderline() : this.isHeaderline;
    }

    @Override
    public boolean isJsonArray() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isJsonArray() : this.isJsonArray;
    }

    @Override
    public boolean dropCollection() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dropCollection() : this.dropCollection;
    }

    @Override
    public boolean upsertDocuments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.upsertDocuments() : this.upsertDocuments;
    }

    public final ImmutableMongoImportArguments withVerbose(boolean value) {
        if (this.verbose == value) {
            return this;
        }
        return new ImmutableMongoImportArguments(value, this.databaseName, this.collectionName, this.importFile, this.type, this.isHeaderline, this.isJsonArray, this.dropCollection, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withDatabaseName(String value) {
        String newValue = Objects.requireNonNull(value, "databaseName");
        if (Objects.equals(this.databaseName, newValue)) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, newValue, this.collectionName, this.importFile, this.type, this.isHeaderline, this.isJsonArray, this.dropCollection, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withDatabaseName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.databaseName, value)) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, value, this.collectionName, this.importFile, this.type, this.isHeaderline, this.isJsonArray, this.dropCollection, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withCollectionName(String value) {
        String newValue = Objects.requireNonNull(value, "collectionName");
        if (Objects.equals(this.collectionName, newValue)) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, this.databaseName, newValue, this.importFile, this.type, this.isHeaderline, this.isJsonArray, this.dropCollection, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withCollectionName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.collectionName, value)) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, this.databaseName, value, this.importFile, this.type, this.isHeaderline, this.isJsonArray, this.dropCollection, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withImportFile(String value) {
        String newValue = Objects.requireNonNull(value, "importFile");
        if (Objects.equals(this.importFile, newValue)) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, this.databaseName, this.collectionName, newValue, this.type, this.isHeaderline, this.isJsonArray, this.dropCollection, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withImportFile(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.importFile, value)) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, this.databaseName, this.collectionName, value, this.type, this.isHeaderline, this.isJsonArray, this.dropCollection, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (Objects.equals(this.type, newValue)) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, this.databaseName, this.collectionName, this.importFile, newValue, this.isHeaderline, this.isJsonArray, this.dropCollection, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, this.databaseName, this.collectionName, this.importFile, value, this.isHeaderline, this.isJsonArray, this.dropCollection, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withIsHeaderline(boolean value) {
        if (this.isHeaderline == value) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, this.databaseName, this.collectionName, this.importFile, this.type, value, this.isJsonArray, this.dropCollection, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withIsJsonArray(boolean value) {
        if (this.isJsonArray == value) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, this.databaseName, this.collectionName, this.importFile, this.type, this.isHeaderline, value, this.dropCollection, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withDropCollection(boolean value) {
        if (this.dropCollection == value) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, this.databaseName, this.collectionName, this.importFile, this.type, this.isHeaderline, this.isJsonArray, value, this.upsertDocuments);
    }

    public final ImmutableMongoImportArguments withUpsertDocuments(boolean value) {
        if (this.upsertDocuments == value) {
            return this;
        }
        return new ImmutableMongoImportArguments(this.verbose, this.databaseName, this.collectionName, this.importFile, this.type, this.isHeaderline, this.isJsonArray, this.dropCollection, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoImportArguments && this.equalsByValue((ImmutableMongoImportArguments)another);
    }

    private boolean equalsByValue(ImmutableMongoImportArguments another) {
        return this.verbose == another.verbose && Objects.equals(this.databaseName, another.databaseName) && Objects.equals(this.collectionName, another.collectionName) && Objects.equals(this.importFile, another.importFile) && Objects.equals(this.type, another.type) && this.isHeaderline == another.isHeaderline && this.isJsonArray == another.isJsonArray && this.dropCollection == another.dropCollection && this.upsertDocuments == another.upsertDocuments;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.verbose);
        h += (h << 5) + Objects.hashCode(this.databaseName);
        h += (h << 5) + Objects.hashCode(this.collectionName);
        h += (h << 5) + Objects.hashCode(this.importFile);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Boolean.hashCode(this.isHeaderline);
        h += (h << 5) + Boolean.hashCode(this.isJsonArray);
        h += (h << 5) + Boolean.hashCode(this.dropCollection);
        h += (h << 5) + Boolean.hashCode(this.upsertDocuments);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MongoImportArguments{");
        builder.append("verbose=").append(this.verbose);
        if (this.databaseName != null) {
            builder.append(", ");
            builder.append("databaseName=").append(this.databaseName);
        }
        if (this.collectionName != null) {
            builder.append(", ");
            builder.append("collectionName=").append(this.collectionName);
        }
        if (this.importFile != null) {
            builder.append(", ");
            builder.append("importFile=").append(this.importFile);
        }
        if (this.type != null) {
            builder.append(", ");
            builder.append("type=").append(this.type);
        }
        builder.append(", ");
        builder.append("isHeaderline=").append(this.isHeaderline);
        builder.append(", ");
        builder.append("isJsonArray=").append(this.isJsonArray);
        builder.append(", ");
        builder.append("dropCollection=").append(this.dropCollection);
        builder.append(", ");
        builder.append("upsertDocuments=").append(this.upsertDocuments);
        return builder.append("}").toString();
    }

    public static ImmutableMongoImportArguments copyOf(MongoImportArguments instance) {
        if (instance instanceof ImmutableMongoImportArguments) {
            return (ImmutableMongoImportArguments)instance;
        }
        return ImmutableMongoImportArguments.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_VERBOSE = 1L;
        private static final long OPT_BIT_TYPE = 2L;
        private static final long OPT_BIT_IS_HEADERLINE = 4L;
        private static final long OPT_BIT_IS_JSON_ARRAY = 8L;
        private static final long OPT_BIT_DROP_COLLECTION = 16L;
        private static final long OPT_BIT_UPSERT_DOCUMENTS = 32L;
        private long optBits;
        private boolean verbose;
        private String databaseName;
        private String collectionName;
        private String importFile;
        private String type;
        private boolean isHeaderline;
        private boolean isJsonArray;
        private boolean dropCollection;
        private boolean upsertDocuments;

        private Builder() {
        }

        public final Builder from(MongoImportArguments instance) {
            Optional<String> typeOptional;
            Optional<String> importFileOptional;
            Optional<String> collectionNameOptional;
            Objects.requireNonNull(instance, "instance");
            this.verbose(instance.verbose());
            Optional<String> databaseNameOptional = instance.databaseName();
            if (databaseNameOptional.isPresent()) {
                this.databaseName(databaseNameOptional);
            }
            if ((collectionNameOptional = instance.collectionName()).isPresent()) {
                this.collectionName(collectionNameOptional);
            }
            if ((importFileOptional = instance.importFile()).isPresent()) {
                this.importFile(importFileOptional);
            }
            if ((typeOptional = instance.type()).isPresent()) {
                this.type(typeOptional);
            }
            this.isHeaderline(instance.isHeaderline());
            this.isJsonArray(instance.isJsonArray());
            this.dropCollection(instance.dropCollection());
            this.upsertDocuments(instance.upsertDocuments());
            return this;
        }

        public final Builder verbose(boolean verbose) {
            this.verbose = verbose;
            this.optBits |= 1L;
            return this;
        }

        public final Builder databaseName(String databaseName) {
            this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
            return this;
        }

        public final Builder databaseName(Optional<String> databaseName) {
            this.databaseName = databaseName.orElse(null);
            return this;
        }

        public final Builder collectionName(String collectionName) {
            this.collectionName = Objects.requireNonNull(collectionName, "collectionName");
            return this;
        }

        public final Builder collectionName(Optional<String> collectionName) {
            this.collectionName = collectionName.orElse(null);
            return this;
        }

        public final Builder importFile(String importFile) {
            this.importFile = Objects.requireNonNull(importFile, "importFile");
            return this;
        }

        public final Builder importFile(Optional<String> importFile) {
            this.importFile = importFile.orElse(null);
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.optBits |= 2L;
            return this;
        }

        public final Builder type(Optional<String> type) {
            this.type = type.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        public final Builder isHeaderline(boolean isHeaderline) {
            this.isHeaderline = isHeaderline;
            this.optBits |= 4L;
            return this;
        }

        public final Builder isJsonArray(boolean isJsonArray) {
            this.isJsonArray = isJsonArray;
            this.optBits |= 8L;
            return this;
        }

        public final Builder dropCollection(boolean dropCollection) {
            this.dropCollection = dropCollection;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder upsertDocuments(boolean upsertDocuments) {
            this.upsertDocuments = upsertDocuments;
            this.optBits |= 0x20L;
            return this;
        }

        public ImmutableMongoImportArguments build() {
            return new ImmutableMongoImportArguments(this);
        }

        private boolean verboseIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean typeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isHeaderlineIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean isJsonArrayIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean dropCollectionIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean upsertDocumentsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }
    }

    private final class InitShim {
        private byte verboseBuildStage = 0;
        private boolean verbose;
        private byte typeBuildStage = 0;
        private String type;
        private byte isHeaderlineBuildStage = 0;
        private boolean isHeaderline;
        private byte isJsonArrayBuildStage = 0;
        private boolean isJsonArray;
        private byte dropCollectionBuildStage = 0;
        private boolean dropCollection;
        private byte upsertDocumentsBuildStage = 0;
        private boolean upsertDocuments;

        private InitShim() {
        }

        boolean verbose() {
            if (this.verboseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.verboseBuildStage == 0) {
                boolean computedValue;
                this.verboseBuildStage = (byte)-1;
                this.verbose = computedValue = ImmutableMongoImportArguments.super.verbose();
                this.verboseBuildStage = 1;
            }
            return this.verbose;
        }

        void verbose(boolean verbose) {
            this.verbose = verbose;
            this.verboseBuildStage = 1;
        }

        String type() {
            if (this.typeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeBuildStage == 0) {
                this.typeBuildStage = (byte)-1;
                Optional computedValue = ImmutableMongoImportArguments.super.type();
                this.type = computedValue.orElse(null);
                this.typeBuildStage = 1;
            }
            return this.type;
        }

        void type(String type) {
            this.type = type;
            this.typeBuildStage = 1;
        }

        boolean isHeaderline() {
            if (this.isHeaderlineBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isHeaderlineBuildStage == 0) {
                boolean computedValue;
                this.isHeaderlineBuildStage = (byte)-1;
                this.isHeaderline = computedValue = ImmutableMongoImportArguments.super.isHeaderline();
                this.isHeaderlineBuildStage = 1;
            }
            return this.isHeaderline;
        }

        void isHeaderline(boolean isHeaderline) {
            this.isHeaderline = isHeaderline;
            this.isHeaderlineBuildStage = 1;
        }

        boolean isJsonArray() {
            if (this.isJsonArrayBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isJsonArrayBuildStage == 0) {
                boolean computedValue;
                this.isJsonArrayBuildStage = (byte)-1;
                this.isJsonArray = computedValue = ImmutableMongoImportArguments.super.isJsonArray();
                this.isJsonArrayBuildStage = 1;
            }
            return this.isJsonArray;
        }

        void isJsonArray(boolean isJsonArray) {
            this.isJsonArray = isJsonArray;
            this.isJsonArrayBuildStage = 1;
        }

        boolean dropCollection() {
            if (this.dropCollectionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dropCollectionBuildStage == 0) {
                boolean computedValue;
                this.dropCollectionBuildStage = (byte)-1;
                this.dropCollection = computedValue = ImmutableMongoImportArguments.super.dropCollection();
                this.dropCollectionBuildStage = 1;
            }
            return this.dropCollection;
        }

        void dropCollection(boolean dropCollection) {
            this.dropCollection = dropCollection;
            this.dropCollectionBuildStage = 1;
        }

        boolean upsertDocuments() {
            if (this.upsertDocumentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.upsertDocumentsBuildStage == 0) {
                boolean computedValue;
                this.upsertDocumentsBuildStage = (byte)-1;
                this.upsertDocuments = computedValue = ImmutableMongoImportArguments.super.upsertDocuments();
                this.upsertDocumentsBuildStage = 1;
            }
            return this.upsertDocuments;
        }

        void upsertDocuments(boolean upsertDocuments) {
            this.upsertDocuments = upsertDocuments;
            this.upsertDocumentsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.verboseBuildStage == -1) {
                attributes.add("verbose");
            }
            if (this.typeBuildStage == -1) {
                attributes.add("type");
            }
            if (this.isHeaderlineBuildStage == -1) {
                attributes.add("isHeaderline");
            }
            if (this.isJsonArrayBuildStage == -1) {
                attributes.add("isJsonArray");
            }
            if (this.dropCollectionBuildStage == -1) {
                attributes.add("dropCollection");
            }
            if (this.upsertDocumentsBuildStage == -1) {
                attributes.add("upsertDocuments");
            }
            return "Cannot build MongoImportArguments, attribute initializers form cycle " + attributes;
        }
    }
}

