/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.client;

import de.flapdoodle.embed.mongo.client.MongoClientAction;
import java.util.ArrayList;
import java.util.Objects;
import org.bson.Document;

final class ImmutableRunCommand
extends MongoClientAction.RunCommand {
    private final String database;
    private final Document command;

    private ImmutableRunCommand(String database, Document command) {
        this.database = Objects.requireNonNull(database, "database");
        this.command = Objects.requireNonNull(command, "command");
    }

    private ImmutableRunCommand(ImmutableRunCommand original, String database, Document command) {
        this.database = database;
        this.command = command;
    }

    @Override
    public String database() {
        return this.database;
    }

    @Override
    public Document command() {
        return this.command;
    }

    public final ImmutableRunCommand withDatabase(String value) {
        String newValue = Objects.requireNonNull(value, "database");
        if (this.database.equals(newValue)) {
            return this;
        }
        return new ImmutableRunCommand(this, newValue, this.command);
    }

    public final ImmutableRunCommand withCommand(Document value) {
        if (this.command == value) {
            return this;
        }
        Document newValue = Objects.requireNonNull(value, "command");
        return new ImmutableRunCommand(this, this.database, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRunCommand && this.equalsByValue((ImmutableRunCommand)another);
    }

    private boolean equalsByValue(ImmutableRunCommand another) {
        return this.database.equals(another.database) && this.command.equals((Object)another.command);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.database.hashCode();
        h += (h << 5) + this.command.hashCode();
        return h;
    }

    public String toString() {
        return "RunCommand{database=" + this.database + ", command=" + this.command + "}";
    }

    public static ImmutableRunCommand of(String database, Document command) {
        return new ImmutableRunCommand(database, command);
    }

    public static ImmutableRunCommand copyOf(MongoClientAction.RunCommand instance) {
        if (instance instanceof ImmutableRunCommand) {
            return (ImmutableRunCommand)instance;
        }
        return ImmutableRunCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DATABASE = 1L;
        private static final long INIT_BIT_COMMAND = 2L;
        private long initBits = 3L;
        private String database;
        private Document command;

        private Builder() {
        }

        public final Builder from(MongoClientAction.RunCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(MongoClientAction.Action instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            MongoClientAction.Action instance;
            if (object instanceof MongoClientAction.RunCommand) {
                instance = (MongoClientAction.RunCommand)object;
                this.command(((MongoClientAction.RunCommand)instance).command());
            }
            if (object instanceof MongoClientAction.Action) {
                instance = (MongoClientAction.Action)object;
                this.database(instance.database());
            }
        }

        public final Builder database(String database) {
            this.database = Objects.requireNonNull(database, "database");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder command(Document command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRunCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRunCommand(null, this.database, this.command);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("database");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("command");
            }
            return "Cannot build RunCommand, some of required attributes are not set " + attributes;
        }
    }
}

