/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import de.flapdoodle.embed.mongo.client.ExecuteMongoClientAction;
import de.flapdoodle.embed.mongo.client.MongoClientAction;
import de.flapdoodle.embed.mongo.commands.ServerAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ReactiveClientAdapter
extends ExecuteMongoClientAction<MongoClient> {
    private final MongoClientSettings clientSettings;

    public ReactiveClientAdapter(MongoClientSettings clientSettings) {
        this.clientSettings = clientSettings;
    }

    @Override
    protected Document resultOfAction(MongoClient client, MongoClientAction.Action action) {
        if (action instanceof MongoClientAction.RunCommand) {
            return (Document)ReactiveClientAdapter.get(client.getDatabase(action.database()).runCommand((Bson)((MongoClientAction.RunCommand)action).command()));
        }
        throw new IllegalArgumentException("Action not supported: " + action);
    }

    @Override
    protected MongoClient client(ServerAddress serverAddress) {
        return MongoClients.create((MongoClientSettings)MongoClientSettings.builder((MongoClientSettings)this.clientSettings).applyConnectionString(new ConnectionString("mongodb://" + serverAddress)).build());
    }

    @Override
    protected MongoClient client(ServerAddress serverAddress, MongoCredential credential) {
        return MongoClients.create((MongoClientSettings)MongoClientSettings.builder((MongoClientSettings)this.clientSettings).applyConnectionString(new ConnectionString("mongodb://" + serverAddress)).credential(credential).build());
    }

    private static <T> T get(Publisher<T> publisher) {
        final CompletableFuture result = new CompletableFuture();
        publisher.subscribe(new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            public void onNext(T t) {
                result.complete(t);
            }

            public void onError(Throwable t) {
                result.completeExceptionally(t);
            }

            public void onComplete() {
            }
        });
        try {
            return result.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

