package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.SupportConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoShellConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoShellConfig.builder()}.
 */
@Generated(from = "MongoShellConfig", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMongoShellConfig implements MongoShellConfig {
  private final Long stopTimeoutInMillis;
  private final IFeatureAwareVersion version;
  private final Timeout timeout;
  private final Net net;
  private final MongoCmdOptions cmdOptions;
  private final String password;
  private final String userName;
  private final List<String> scriptParameters;
  private final String scriptName;
  private final String dbName;
  private final String pidFile;
  private final SupportConfig supportConfig;

  private ImmutableMongoShellConfig(ImmutableMongoShellConfig.Builder builder) {
    this.stopTimeoutInMillis = builder.stopTimeoutInMillis;
    this.version = builder.version;
    this.scriptParameters = createUnmodifiableList(true, builder.scriptParameters);
    this.scriptName = builder.scriptName;
    this.dbName = builder.dbName;
    if (builder.timeout != null) {
      initShim.timeout(builder.timeout);
    }
    if (builder.net != null) {
      initShim.net(builder.net);
    }
    if (builder.cmdOptions != null) {
      initShim.cmdOptions(builder.cmdOptions);
    }
    if (builder.password != null) {
      initShim.password(builder.password);
    }
    if (builder.userName != null) {
      initShim.userName(builder.userName);
    }
    if (builder.pidFile != null) {
      initShim.pidFile(builder.pidFile);
    }
    if (builder.supportConfig != null) {
      initShim.supportConfig(builder.supportConfig);
    }
    this.timeout = initShim.timeout();
    this.net = initShim.net();
    this.cmdOptions = initShim.cmdOptions();
    this.password = initShim.password();
    this.userName = initShim.userName();
    this.pidFile = initShim.pidFile();
    this.supportConfig = initShim.supportConfig();
    this.initShim = null;
  }

  private ImmutableMongoShellConfig(
      Long stopTimeoutInMillis,
      IFeatureAwareVersion version,
      Timeout timeout,
      Net net,
      MongoCmdOptions cmdOptions,
      String password,
      String userName,
      List<String> scriptParameters,
      String scriptName,
      String dbName,
      String pidFile,
      SupportConfig supportConfig) {
    this.stopTimeoutInMillis = stopTimeoutInMillis;
    this.version = version;
    this.timeout = timeout;
    this.net = net;
    this.cmdOptions = cmdOptions;
    this.password = password;
    this.userName = userName;
    this.scriptParameters = scriptParameters;
    this.scriptName = scriptName;
    this.dbName = dbName;
    this.pidFile = pidFile;
    this.supportConfig = supportConfig;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MongoShellConfig", generator = "Immutables")
  private final class InitShim {
    private byte timeoutBuildStage = STAGE_UNINITIALIZED;
    private Timeout timeout;

    Timeout timeout() {
      if (timeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (timeoutBuildStage == STAGE_UNINITIALIZED) {
        timeoutBuildStage = STAGE_INITIALIZING;
        this.timeout = Objects.requireNonNull(timeoutInitialize(), "timeout");
        timeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.timeout;
    }

    void timeout(Timeout timeout) {
      this.timeout = timeout;
      timeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte netBuildStage = STAGE_UNINITIALIZED;
    private Net net;

    Net net() {
      if (netBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (netBuildStage == STAGE_UNINITIALIZED) {
        netBuildStage = STAGE_INITIALIZING;
        this.net = Objects.requireNonNull(netInitialize(), "net");
        netBuildStage = STAGE_INITIALIZED;
      }
      return this.net;
    }

    void net(Net net) {
      this.net = net;
      netBuildStage = STAGE_INITIALIZED;
    }

    private byte cmdOptionsBuildStage = STAGE_UNINITIALIZED;
    private MongoCmdOptions cmdOptions;

    MongoCmdOptions cmdOptions() {
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cmdOptionsBuildStage == STAGE_UNINITIALIZED) {
        cmdOptionsBuildStage = STAGE_INITIALIZING;
        this.cmdOptions = Objects.requireNonNull(cmdOptionsInitialize(), "cmdOptions");
        cmdOptionsBuildStage = STAGE_INITIALIZED;
      }
      return this.cmdOptions;
    }

    void cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = cmdOptions;
      cmdOptionsBuildStage = STAGE_INITIALIZED;
    }

    private byte passwordBuildStage = STAGE_UNINITIALIZED;
    private String password;

    String password() {
      if (passwordBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (passwordBuildStage == STAGE_UNINITIALIZED) {
        passwordBuildStage = STAGE_INITIALIZING;
        this.password = Objects.requireNonNull(passwordInitialize(), "password");
        passwordBuildStage = STAGE_INITIALIZED;
      }
      return this.password;
    }

    void password(String password) {
      this.password = password;
      passwordBuildStage = STAGE_INITIALIZED;
    }

    private byte userNameBuildStage = STAGE_UNINITIALIZED;
    private String userName;

    String userName() {
      if (userNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (userNameBuildStage == STAGE_UNINITIALIZED) {
        userNameBuildStage = STAGE_INITIALIZING;
        this.userName = Objects.requireNonNull(userNameInitialize(), "userName");
        userNameBuildStage = STAGE_INITIALIZED;
      }
      return this.userName;
    }

    void userName(String userName) {
      this.userName = userName;
      userNameBuildStage = STAGE_INITIALIZED;
    }

    private byte pidFileBuildStage = STAGE_UNINITIALIZED;
    private String pidFile;

    String pidFile() {
      if (pidFileBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pidFileBuildStage == STAGE_UNINITIALIZED) {
        pidFileBuildStage = STAGE_INITIALIZING;
        this.pidFile = Objects.requireNonNull(pidFileInitialize(), "pidFile");
        pidFileBuildStage = STAGE_INITIALIZED;
      }
      return this.pidFile;
    }

    void pidFile(String pidFile) {
      this.pidFile = pidFile;
      pidFileBuildStage = STAGE_INITIALIZED;
    }

    private byte supportConfigBuildStage = STAGE_UNINITIALIZED;
    private SupportConfig supportConfig;

    SupportConfig supportConfig() {
      if (supportConfigBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (supportConfigBuildStage == STAGE_UNINITIALIZED) {
        supportConfigBuildStage = STAGE_INITIALIZING;
        this.supportConfig = Objects.requireNonNull(supportConfigInitialize(), "supportConfig");
        supportConfigBuildStage = STAGE_INITIALIZED;
      }
      return this.supportConfig;
    }

    void supportConfig(SupportConfig supportConfig) {
      this.supportConfig = supportConfig;
      supportConfigBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (timeoutBuildStage == STAGE_INITIALIZING) attributes.add("timeout");
      if (netBuildStage == STAGE_INITIALIZING) attributes.add("net");
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) attributes.add("cmdOptions");
      if (passwordBuildStage == STAGE_INITIALIZING) attributes.add("password");
      if (userNameBuildStage == STAGE_INITIALIZING) attributes.add("userName");
      if (pidFileBuildStage == STAGE_INITIALIZING) attributes.add("pidFile");
      if (supportConfigBuildStage == STAGE_INITIALIZING) attributes.add("supportConfig");
      return "Cannot build MongoShellConfig, attribute initializers form cycle " + attributes;
    }
  }

  private Timeout timeoutInitialize() {
    return MongoShellConfig.super.timeout();
  }

  private Net netInitialize() {
    return MongoShellConfig.super.net();
  }

  private MongoCmdOptions cmdOptionsInitialize() {
    return MongoShellConfig.super.cmdOptions();
  }

  private String passwordInitialize() {
    return MongoShellConfig.super.password();
  }

  private String userNameInitialize() {
    return MongoShellConfig.super.userName();
  }

  private String pidFileInitialize() {
    return MongoShellConfig.super.pidFile();
  }

  private SupportConfig supportConfigInitialize() {
    return MongoShellConfig.super.supportConfig();
  }

  /**
   * @return The value of the {@code stopTimeoutInMillis} attribute
   */
  @Override
  public OptionalLong stopTimeoutInMillis() {
    return stopTimeoutInMillis != null
        ? OptionalLong.of(stopTimeoutInMillis)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public IFeatureAwareVersion version() {
    return version;
  }

  /**
   * @return The value of the {@code timeout} attribute
   */
  @Override
  public Timeout timeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.timeout()
        : this.timeout;
  }

  /**
   * @return The value of the {@code net} attribute
   */
  @Override
  public Net net() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.net()
        : this.net;
  }

  /**
   * @return The value of the {@code cmdOptions} attribute
   */
  @Override
  public MongoCmdOptions cmdOptions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.cmdOptions()
        : this.cmdOptions;
  }

  /**
   * @return The value of the {@code password} attribute
   */
  @Override
  public String password() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.password()
        : this.password;
  }

  /**
   * @return The value of the {@code userName} attribute
   */
  @Override
  public String userName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.userName()
        : this.userName;
  }

  /**
   * @return The value of the {@code scriptParameters} attribute
   */
  @Override
  public List<String> getScriptParameters() {
    return scriptParameters;
  }

  /**
   * @return The value of the {@code scriptName} attribute
   */
  @Override
  public String getScriptName() {
    return scriptName;
  }

  /**
   * @return The value of the {@code dbName} attribute
   */
  @Override
  public String getDbName() {
    return dbName;
  }

  /**
   * @return The value of the {@code pidFile} attribute
   */
  @Override
  public String pidFile() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.pidFile()
        : this.pidFile;
  }

  /**
   * @return The value of the {@code supportConfig} attribute
   */
  @Override
  public SupportConfig supportConfig() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.supportConfig()
        : this.supportConfig;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoShellConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * @param value The value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoShellConfig withStopTimeoutInMillis(long value) {
    Long newValue = value;
    if (Objects.equals(this.stopTimeoutInMillis, newValue)) return this;
    return new ImmutableMongoShellConfig(
        newValue,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.scriptParameters,
        this.scriptName,
        this.dbName,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoShellConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoShellConfig withStopTimeoutInMillis(OptionalLong optional) {
    Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.stopTimeoutInMillis, value)) return this;
    return new ImmutableMongoShellConfig(
        value,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.scriptParameters,
        this.scriptName,
        this.dbName,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoShellConfig#version() version} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoShellConfig withVersion(IFeatureAwareVersion value) {
    if (this.version == value) return this;
    IFeatureAwareVersion newValue = Objects.requireNonNull(value, "version");
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        newValue,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.scriptParameters,
        this.scriptName,
        this.dbName,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoShellConfig#timeout() timeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeout
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoShellConfig withTimeout(Timeout value) {
    if (this.timeout == value) return this;
    Timeout newValue = Objects.requireNonNull(value, "timeout");
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        this.version,
        newValue,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.scriptParameters,
        this.scriptName,
        this.dbName,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoShellConfig#net() net} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for net
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoShellConfig withNet(Net value) {
    if (this.net == value) return this;
    Net newValue = Objects.requireNonNull(value, "net");
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        newValue,
        this.cmdOptions,
        this.password,
        this.userName,
        this.scriptParameters,
        this.scriptName,
        this.dbName,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoShellConfig#cmdOptions() cmdOptions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cmdOptions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoShellConfig withCmdOptions(MongoCmdOptions value) {
    if (this.cmdOptions == value) return this;
    MongoCmdOptions newValue = Objects.requireNonNull(value, "cmdOptions");
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        newValue,
        this.password,
        this.userName,
        this.scriptParameters,
        this.scriptName,
        this.dbName,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoShellConfig#password() password} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for password
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoShellConfig withPassword(String value) {
    String newValue = Objects.requireNonNull(value, "password");
    if (this.password.equals(newValue)) return this;
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        newValue,
        this.userName,
        this.scriptParameters,
        this.scriptName,
        this.dbName,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoShellConfig#userName() userName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoShellConfig withUserName(String value) {
    String newValue = Objects.requireNonNull(value, "userName");
    if (this.userName.equals(newValue)) return this;
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        newValue,
        this.scriptParameters,
        this.scriptName,
        this.dbName,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MongoShellConfig#getScriptParameters() scriptParameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoShellConfig withScriptParameters(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        newValue,
        this.scriptName,
        this.dbName,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MongoShellConfig#getScriptParameters() scriptParameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of scriptParameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoShellConfig withScriptParameters(Iterable<String> elements) {
    if (this.scriptParameters == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        newValue,
        this.scriptName,
        this.dbName,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoShellConfig#getScriptName() scriptName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scriptName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoShellConfig withScriptName(String value) {
    String newValue = Objects.requireNonNull(value, "scriptName");
    if (this.scriptName.equals(newValue)) return this;
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.scriptParameters,
        newValue,
        this.dbName,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoShellConfig#getDbName() dbName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dbName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoShellConfig withDbName(String value) {
    String newValue = Objects.requireNonNull(value, "dbName");
    if (this.dbName.equals(newValue)) return this;
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.scriptParameters,
        this.scriptName,
        newValue,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoShellConfig#pidFile() pidFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pidFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoShellConfig withPidFile(String value) {
    String newValue = Objects.requireNonNull(value, "pidFile");
    if (this.pidFile.equals(newValue)) return this;
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.scriptParameters,
        this.scriptName,
        this.dbName,
        newValue,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoShellConfig#supportConfig() supportConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for supportConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoShellConfig withSupportConfig(SupportConfig value) {
    if (this.supportConfig == value) return this;
    SupportConfig newValue = Objects.requireNonNull(value, "supportConfig");
    return new ImmutableMongoShellConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.scriptParameters,
        this.scriptName,
        this.dbName,
        this.pidFile,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoShellConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoShellConfig
        && equalTo((ImmutableMongoShellConfig) another);
  }

  private boolean equalTo(ImmutableMongoShellConfig another) {
    return Objects.equals(stopTimeoutInMillis, another.stopTimeoutInMillis)
        && version.equals(another.version)
        && timeout.equals(another.timeout)
        && net.equals(another.net)
        && cmdOptions.equals(another.cmdOptions)
        && password.equals(another.password)
        && userName.equals(another.userName)
        && scriptParameters.equals(another.scriptParameters)
        && scriptName.equals(another.scriptName)
        && dbName.equals(another.dbName)
        && pidFile.equals(another.pidFile)
        && supportConfig.equals(another.supportConfig);
  }

  /**
   * Computes a hash code from attributes: {@code stopTimeoutInMillis}, {@code version}, {@code timeout}, {@code net}, {@code cmdOptions}, {@code password}, {@code userName}, {@code scriptParameters}, {@code scriptName}, {@code dbName}, {@code pidFile}, {@code supportConfig}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(stopTimeoutInMillis);
    h += (h << 5) + version.hashCode();
    h += (h << 5) + timeout.hashCode();
    h += (h << 5) + net.hashCode();
    h += (h << 5) + cmdOptions.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + userName.hashCode();
    h += (h << 5) + scriptParameters.hashCode();
    h += (h << 5) + scriptName.hashCode();
    h += (h << 5) + dbName.hashCode();
    h += (h << 5) + pidFile.hashCode();
    h += (h << 5) + supportConfig.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongoShellConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MongoShellConfig{");
    if (stopTimeoutInMillis != null) {
      builder.append("stopTimeoutInMillis=").append(stopTimeoutInMillis);
    }
    if (builder.length() > 17) builder.append(", ");
    builder.append("version=").append(version);
    builder.append(", ");
    builder.append("timeout=").append(timeout);
    builder.append(", ");
    builder.append("net=").append(net);
    builder.append(", ");
    builder.append("cmdOptions=").append(cmdOptions);
    builder.append(", ");
    builder.append("password=").append(password);
    builder.append(", ");
    builder.append("userName=").append(userName);
    builder.append(", ");
    builder.append("scriptParameters=").append(scriptParameters);
    builder.append(", ");
    builder.append("scriptName=").append(scriptName);
    builder.append(", ");
    builder.append("dbName=").append(dbName);
    builder.append(", ");
    builder.append("pidFile=").append(pidFile);
    builder.append(", ");
    builder.append("supportConfig=").append(supportConfig);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MongoShellConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoShellConfig instance
   */
  public static ImmutableMongoShellConfig copyOf(MongoShellConfig instance) {
    if (instance instanceof ImmutableMongoShellConfig) {
      return (ImmutableMongoShellConfig) instance;
    }
    return ImmutableMongoShellConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoShellConfig ImmutableMongoShellConfig}.
   * <pre>
   * ImmutableMongoShellConfig.builder()
   *    .stopTimeoutInMillis(long) // optional {@link MongoShellConfig#stopTimeoutInMillis() stopTimeoutInMillis}
   *    .version(de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion) // required {@link MongoShellConfig#version() version}
   *    .timeout(de.flapdoodle.embed.mongo.config.Timeout) // optional {@link MongoShellConfig#timeout() timeout}
   *    .net(de.flapdoodle.embed.mongo.config.Net) // optional {@link MongoShellConfig#net() net}
   *    .cmdOptions(de.flapdoodle.embed.mongo.config.MongoCmdOptions) // optional {@link MongoShellConfig#cmdOptions() cmdOptions}
   *    .password(String) // optional {@link MongoShellConfig#password() password}
   *    .userName(String) // optional {@link MongoShellConfig#userName() userName}
   *    .addScriptParameters|addAllScriptParameters(String) // {@link MongoShellConfig#getScriptParameters() scriptParameters} elements
   *    .scriptName(String) // required {@link MongoShellConfig#getScriptName() scriptName}
   *    .dbName(String) // required {@link MongoShellConfig#getDbName() dbName}
   *    .pidFile(String) // optional {@link MongoShellConfig#pidFile() pidFile}
   *    .supportConfig(de.flapdoodle.embed.process.config.SupportConfig) // optional {@link MongoShellConfig#supportConfig() supportConfig}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoShellConfig builder
   */
  public static ImmutableMongoShellConfig.Builder builder() {
    return new ImmutableMongoShellConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoShellConfig ImmutableMongoShellConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoShellConfig", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_SCRIPT_NAME = 0x2L;
    private static final long INIT_BIT_DB_NAME = 0x4L;
    private long initBits = 0x7L;

    private Long stopTimeoutInMillis;
    private IFeatureAwareVersion version;
    private Timeout timeout;
    private Net net;
    private MongoCmdOptions cmdOptions;
    private String password;
    private String userName;
    private List<String> scriptParameters = new ArrayList<String>();
    private String scriptName;
    private String dbName;
    private String pidFile;
    private SupportConfig supportConfig;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongoShellConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoShellConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongoCommonConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoCommonConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.process.config.ExecutableProcessConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExecutableProcessConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof MongoShellConfig) {
        MongoShellConfig instance = (MongoShellConfig) object;
        addAllScriptParameters(instance.getScriptParameters());
        scriptName(instance.getScriptName());
        if ((bits & 0x1L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          version(instance.version());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x4L;
        }
        dbName(instance.getDbName());
      }
      if (object instanceof MongoCommonConfig) {
        MongoCommonConfig instance = (MongoCommonConfig) object;
        password(instance.password());
        cmdOptions(instance.cmdOptions());
        net(instance.net());
        userName(instance.userName());
        if ((bits & 0x2L) == 0) {
          version(instance.version());
          bits |= 0x2L;
        }
        timeout(instance.timeout());
        if ((bits & 0x4L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x4L;
        }
      }
      if (object instanceof ExecutableProcessConfig) {
        ExecutableProcessConfig instance = (ExecutableProcessConfig) object;
        if ((bits & 0x1L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x1L;
        }
        OptionalLong stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
        if (stopTimeoutInMillisOptional.isPresent()) {
          stopTimeoutInMillis(stopTimeoutInMillisOptional);
        }
      }
    }

    /**
     * Initializes the optional value {@link MongoShellConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder stopTimeoutInMillis(long stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoShellConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stopTimeoutInMillis(OptionalLong stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis.isPresent() ? stopTimeoutInMillis.getAsLong() : null;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoShellConfig#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(IFeatureAwareVersion version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoShellConfig#timeout() timeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoShellConfig#timeout() timeout}.</em>
     * @param timeout The value for timeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timeout(Timeout timeout) {
      this.timeout = Objects.requireNonNull(timeout, "timeout");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoShellConfig#net() net} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoShellConfig#net() net}.</em>
     * @param net The value for net 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder net(Net net) {
      this.net = Objects.requireNonNull(net, "net");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoShellConfig#cmdOptions() cmdOptions} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoShellConfig#cmdOptions() cmdOptions}.</em>
     * @param cmdOptions The value for cmdOptions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = Objects.requireNonNull(cmdOptions, "cmdOptions");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoShellConfig#password() password} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoShellConfig#password() password}.</em>
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoShellConfig#userName() userName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoShellConfig#userName() userName}.</em>
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      return this;
    }

    /**
     * Adds one element to {@link MongoShellConfig#getScriptParameters() scriptParameters} list.
     * @param element A scriptParameters element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addScriptParameters(String element) {
      this.scriptParameters.add(Objects.requireNonNull(element, "scriptParameters element"));
      return this;
    }

    /**
     * Adds elements to {@link MongoShellConfig#getScriptParameters() scriptParameters} list.
     * @param elements An array of scriptParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addScriptParameters(String... elements) {
      for (String element : elements) {
        this.scriptParameters.add(Objects.requireNonNull(element, "scriptParameters element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MongoShellConfig#getScriptParameters() scriptParameters} list.
     * @param elements An iterable of scriptParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scriptParameters(Iterable<String> elements) {
      this.scriptParameters.clear();
      return addAllScriptParameters(elements);
    }

    /**
     * Adds elements to {@link MongoShellConfig#getScriptParameters() scriptParameters} list.
     * @param elements An iterable of scriptParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllScriptParameters(Iterable<String> elements) {
      for (String element : elements) {
        this.scriptParameters.add(Objects.requireNonNull(element, "scriptParameters element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MongoShellConfig#getScriptName() scriptName} attribute.
     * @param scriptName The value for scriptName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scriptName(String scriptName) {
      this.scriptName = Objects.requireNonNull(scriptName, "scriptName");
      initBits &= ~INIT_BIT_SCRIPT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoShellConfig#getDbName() dbName} attribute.
     * @param dbName The value for dbName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dbName(String dbName) {
      this.dbName = Objects.requireNonNull(dbName, "dbName");
      initBits &= ~INIT_BIT_DB_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoShellConfig#pidFile() pidFile} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoShellConfig#pidFile() pidFile}.</em>
     * @param pidFile The value for pidFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pidFile(String pidFile) {
      this.pidFile = Objects.requireNonNull(pidFile, "pidFile");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoShellConfig#supportConfig() supportConfig} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoShellConfig#supportConfig() supportConfig}.</em>
     * @param supportConfig The value for supportConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportConfig(SupportConfig supportConfig) {
      this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoShellConfig ImmutableMongoShellConfig}.
     * @return An immutable instance of MongoShellConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoShellConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMongoShellConfig(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_SCRIPT_NAME) != 0) attributes.add("scriptName");
      if ((initBits & INIT_BIT_DB_NAME) != 0) attributes.add("dbName");
      return "Cannot build MongoShellConfig, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
