/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.TypedProperty;

public class MongoCmdOptionsBuilder
extends AbstractBuilder<IMongoCmdOptions> {
    protected static final TypedProperty<Integer> SYNC_DELAY = TypedProperty.with((String)"syncDelay", Integer.class);
    protected static final TypedProperty<Boolean> VERBOSE = TypedProperty.with((String)"verbose", Boolean.class);
    protected static final TypedProperty<Boolean> NOPREALLOC = TypedProperty.with((String)"noprealloc", Boolean.class);
    protected static final TypedProperty<Boolean> SMALLFILES = TypedProperty.with((String)"smallfiles", Boolean.class);
    protected static final TypedProperty<Boolean> NOJOURNAL = TypedProperty.with((String)"nojournal", Boolean.class);

    public MongoCmdOptionsBuilder() {
        this.property(SYNC_DELAY).setDefault((Object)0);
        this.property(VERBOSE).setDefault((Object)false);
        this.property(NOPREALLOC).setDefault((Object)true);
        this.property(SMALLFILES).setDefault((Object)true);
        this.property(NOJOURNAL).setDefault((Object)true);
    }

    public MongoCmdOptionsBuilder useNoPrealloc(boolean value) {
        this.set(NOPREALLOC, value);
        return this;
    }

    public MongoCmdOptionsBuilder useSmallFiles(boolean value) {
        this.set(SMALLFILES, value);
        return this;
    }

    public MongoCmdOptionsBuilder useNoJournal(boolean value) {
        this.set(NOJOURNAL, value);
        return this;
    }

    public MongoCmdOptionsBuilder syncDelay(int delay) {
        this.set(SYNC_DELAY, delay);
        return this;
    }

    public MongoCmdOptionsBuilder verbose(boolean verbose) {
        this.set(VERBOSE, verbose);
        return this;
    }

    public MongoCmdOptionsBuilder defaultSyncDelay() {
        this.set(SYNC_DELAY, null);
        return this;
    }

    public IMongoCmdOptions build() {
        Integer syncDelay = (Integer)this.get(SYNC_DELAY, null);
        boolean verbose = (Boolean)this.get(VERBOSE);
        boolean noPrealloc = (Boolean)this.get(NOPREALLOC);
        boolean smallFiles = (Boolean)this.get(SMALLFILES);
        boolean noJournal = (Boolean)this.get(NOJOURNAL);
        return new MongoCmdOptions(syncDelay, verbose, noPrealloc, smallFiles, noJournal);
    }

    static class MongoCmdOptions
    implements IMongoCmdOptions {
        private final Integer _syncDelay;
        private final boolean _verbose;
        private final boolean _noPrealloc;
        private final boolean _smallFiles;
        private final boolean _noJournal;

        public MongoCmdOptions(Integer syncDelay, boolean verbose, boolean noPrealloc, boolean smallFiles, boolean noJournal) {
            this._syncDelay = syncDelay;
            this._verbose = verbose;
            this._noPrealloc = noPrealloc;
            this._smallFiles = smallFiles;
            this._noJournal = noJournal;
        }

        @Override
        public Integer syncDelay() {
            return this._syncDelay;
        }

        @Override
        public boolean isVerbose() {
            return this._verbose;
        }

        @Override
        public boolean useNoPrealloc() {
            return this._noPrealloc;
        }

        @Override
        public boolean useSmallFiles() {
            return this._smallFiles;
        }

        @Override
        public boolean useNoJournal() {
            return this._noJournal;
        }
    }
}

