/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.AbstractMongoConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.mongo.config.IMongosConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.TypedProperty;
import java.io.IOException;
import java.net.UnknownHostException;

public class MongosConfigBuilder
extends AbstractMongoConfigBuilder<IMongosConfig> {
    protected static final TypedProperty<String> CONFIG_DB = TypedProperty.with((String)"ConfigDB", String.class);

    public MongosConfigBuilder() throws UnknownHostException, IOException {
        this.property(PID_FILE).setDefault((Object)"mongos.pid");
    }

    public MongosConfigBuilder version(IFeatureAwareVersion version) {
        this.version().set((Object)version);
        return this;
    }

    public MongosConfigBuilder timeout(Timeout timeout) {
        this.timeout().set((Object)timeout);
        return this;
    }

    public MongosConfigBuilder net(Net net) {
        this.net().set((Object)net);
        return this;
    }

    public MongosConfigBuilder cmdOptions(IMongoCmdOptions cmdOptions) {
        this.cmdOptions().set((Object)cmdOptions);
        return this;
    }

    public MongosConfigBuilder configDB(String configDB) {
        this.set(CONFIG_DB, configDB);
        return this;
    }

    public IMongosConfig build() {
        IFeatureAwareVersion version = (IFeatureAwareVersion)this.version().get();
        Net net = (Net)this.net().get();
        Timeout timeout = (Timeout)this.timeout().get();
        String configDB = (String)this.get(CONFIG_DB);
        IMongoCmdOptions cmdOptions = (IMongoCmdOptions)this.get(CMD_OPTIONS);
        String pidFile = (String)this.get(PID_FILE);
        return new ImmutableMongosConfig(version, net, timeout, cmdOptions, pidFile, configDB);
    }

    static class ImmutableMongosConfig
    extends AbstractMongoConfigBuilder.ImmutableMongoConfig
    implements IMongosConfig {
        private final String _configDB;

        public ImmutableMongosConfig(IFeatureAwareVersion version, Net net, Timeout timeout, IMongoCmdOptions cmdOptions, String pidFile, String configDB) {
            super(version, net, timeout, cmdOptions, pidFile);
            this._configDB = configDB;
        }

        @Override
        public String getConfigDB() {
            return this._configDB;
        }
    }
}

