/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.web.client.InstanceExchangeFilterFunction;
import de.codecentric.boot.admin.server.web.client.exception.ResolveInstanceException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class InstanceWebClient {
    public static final String ATTRIBUTE_INSTANCE = "instance";
    private final WebClient webClient;

    protected InstanceWebClient(WebClient webClient) {
        this.webClient = webClient;
    }

    public WebClient instance(Mono<Instance> instance) {
        return this.webClient.mutate().filters(filters -> filters.add(0, InstanceWebClient.setInstance(instance))).build();
    }

    public WebClient instance(Instance instance) {
        return this.instance((Mono<Instance>)Mono.justOrEmpty((Object)instance));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebClient.Builder webClient) {
        return new Builder(webClient);
    }

    private static ExchangeFilterFunction setInstance(Mono<Instance> instance) {
        return (request, next) -> instance.map(i -> ClientRequest.from((ClientRequest)request).attribute(ATTRIBUTE_INSTANCE, i).build()).switchIfEmpty(Mono.error(() -> new ResolveInstanceException("Could not resolve Instance"))).flatMap(arg_0 -> ((ExchangeFunction)next).exchange(arg_0));
    }

    private static ExchangeFilterFunction toExchangeFilterFunction(InstanceExchangeFilterFunction filter) {
        return (request, next) -> request.attribute(ATTRIBUTE_INSTANCE).filter(Instance.class::isInstance).map(Instance.class::cast).map(instance -> filter.filter((Instance)instance, request, next)).orElse(next.exchange(request));
    }

    public static class Builder {
        private List<InstanceExchangeFilterFunction> filters = new ArrayList<InstanceExchangeFilterFunction>();
        private WebClient.Builder webClientBuilder;

        public Builder() {
            this(WebClient.builder());
        }

        public Builder(WebClient.Builder webClientBuilder) {
            this.webClientBuilder = webClientBuilder;
        }

        protected Builder(Builder other) {
            this.filters = new ArrayList<InstanceExchangeFilterFunction>(other.filters);
            this.webClientBuilder = other.webClientBuilder.clone();
        }

        public Builder filter(InstanceExchangeFilterFunction filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder filters(Consumer<List<InstanceExchangeFilterFunction>> filtersConsumer) {
            filtersConsumer.accept(this.filters);
            return this;
        }

        public Builder webClient(WebClient.Builder builder) {
            this.webClientBuilder = builder;
            return this;
        }

        public Builder clone() {
            return new Builder(this);
        }

        public InstanceWebClient build() {
            this.filters.stream().map(x$0 -> InstanceWebClient.toExchangeFilterFunction(x$0)).forEach(arg_0 -> ((WebClient.Builder)this.webClientBuilder).filter(arg_0));
            return new InstanceWebClient(this.webClientBuilder.build());
        }
    }
}

