/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.web;

import de.codecentric.boot.admin.server.ui.extensions.UiExtension;
import de.codecentric.boot.admin.server.web.AdminController;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@AdminController
public class UiController {
    private final String publicUrl;
    private final List<UiExtension> cssExtensions;
    private final List<UiExtension> jsExtensions;
    private final Map<String, Object> uiSettings;

    public UiController(String publicUrl, String title, String brand, String favicon, String faviconDanger, List<UiExtension> uiExtensions, boolean notificationFilterEnabled) {
        this.publicUrl = publicUrl;
        this.uiSettings = new HashMap<String, Object>();
        this.uiSettings.put("title", title);
        this.uiSettings.put("brand", brand);
        this.uiSettings.put("favicon", favicon);
        this.uiSettings.put("faviconDanger", faviconDanger);
        this.uiSettings.put("notificationFilterEnabled", notificationFilterEnabled);
        this.cssExtensions = uiExtensions.stream().filter(e -> e.getResourcePath().endsWith(".css")).collect(Collectors.toList());
        this.jsExtensions = uiExtensions.stream().filter(e -> e.getResourcePath().endsWith(".js")).collect(Collectors.toList());
    }

    @ModelAttribute(value="baseUrl", binding=false)
    public String getBaseUrl(UriComponentsBuilder uriBuilder) {
        UriComponents publicComponents = UriComponentsBuilder.fromUriString((String)this.publicUrl).build();
        if (publicComponents.getScheme() != null) {
            uriBuilder.scheme(publicComponents.getScheme());
        }
        if (publicComponents.getHost() != null) {
            uriBuilder.host(publicComponents.getHost());
        }
        if (publicComponents.getPort() != -1) {
            uriBuilder.port(publicComponents.getPort());
        }
        if (publicComponents.getPath() != null) {
            uriBuilder.path(publicComponents.getPath());
        }
        return uriBuilder.path("/").toUriString();
    }

    @ModelAttribute(value="uiSettings", binding=false)
    public Map<String, Object> getUiSettings() {
        return this.uiSettings;
    }

    @ModelAttribute(value="cssExtensions", binding=false)
    public List<UiExtension> getCssExtensions() {
        return this.cssExtensions;
    }

    @ModelAttribute(value="jsExtensions", binding=false)
    public List<UiExtension> getJsExtensions() {
        return this.jsExtensions;
    }

    @ModelAttribute(value="user", binding=false)
    public Map<String, Object> getUser(@Nullable Principal principal) {
        if (principal != null) {
            return Collections.singletonMap("name", principal.getName());
        }
        return Collections.emptyMap();
    }

    @GetMapping(path={"/"}, produces={"text/html"})
    public String index() {
        return "index";
    }

    @GetMapping(path={"/sba-settings.js"}, produces={"text/javascript"})
    public String sbaSettings() {
        return "sba-settings.js";
    }

    @GetMapping(path={"/login"}, produces={"text/html"})
    public String login() {
        return "login";
    }
}

