/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.path;

import com.yahoo.api.annotations.Beta;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@Beta
public final class Path {
    private final String delimiter;
    private final List<String> elements;

    private Path(String delimiter) {
        this(List.of(), delimiter);
    }

    private Path(List<String> elements, String delimiter) {
        for (String element : elements) {
            if (!"..".equals(element)) continue;
            throw new IllegalArgumentException("'..' is not allowed in path");
        }
        this.elements = List.copyOf(elements);
        this.delimiter = delimiter;
    }

    public static Path from(List<String> segments) {
        return new Path(segments, "/");
    }

    public boolean isChildOf(Path parent) {
        return this.toString().startsWith(parent.toString()) && this.elements.size() - 1 == parent.elements.size();
    }

    private static List<String> elementsOf(String path, String delimiter) {
        return Arrays.stream(path.split(delimiter)).filter(e -> !"".equals(e)).toList();
    }

    public Path append(String path) {
        ArrayList<String> newElements = new ArrayList<String>(this.elements);
        newElements.addAll(Path.elementsOf(path, this.delimiter));
        return new Path(newElements, this.delimiter);
    }

    public Path append(Path path) {
        ArrayList<String> newElements = new ArrayList<String>(this.elements);
        newElements.addAll(path.elements());
        return new Path(newElements, this.delimiter);
    }

    public String getName() {
        if (this.elements.isEmpty()) {
            return "";
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public String getRelative() {
        if (this.elements.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.elements.get(0));
        for (int i = 1; i < this.elements.size(); ++i) {
            sb.append(this.delimiter);
            sb.append(this.elements.get(i));
        }
        return sb.toString();
    }

    public Path getParentPath() {
        ArrayList<String> parentElements = new ArrayList<String>();
        if (this.elements.size() > 1) {
            for (int i = 0; i < this.elements.size() - 1; ++i) {
                parentElements.add(this.elements.get(i));
            }
        }
        return new Path(parentElements, this.delimiter);
    }

    public Path getChildPath() {
        ArrayList<String> childElements = new ArrayList<String>();
        if (this.elements.size() > 1) {
            for (int i = 1; i < this.elements.size(); ++i) {
                childElements.add(this.elements.get(i));
            }
        }
        return new Path(childElements, this.delimiter);
    }

    public String last() {
        if (this.elements.isEmpty()) {
            return "";
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public Path withLast(String element) {
        if (element.contains(this.delimiter)) {
            throw new IllegalArgumentException("single element cannot contain delimiter " + this.delimiter);
        }
        if (element.isEmpty()) {
            throw new IllegalStateException("Cannot set the last element of an empty path");
        }
        ArrayList<String> newElements = new ArrayList<String>(this.elements);
        newElements.set(newElements.size() - 1, element);
        return new Path(newElements, this.delimiter);
    }

    public String getAbsolute() {
        return this.delimiter + this.getRelative();
    }

    public boolean isRoot() {
        return this.elements.isEmpty();
    }

    public Iterator<String> iterator() {
        return this.elements.iterator();
    }

    public List<String> elements() {
        return this.elements;
    }

    public String toString() {
        return this.getRelative();
    }

    public static Path fromString(String path) {
        return Path.fromString(path, "/");
    }

    public static Path fromString(String path, String delimiter) {
        return new Path(Path.elementsOf(path, delimiter), delimiter);
    }

    public static Path createRoot() {
        return Path.createRoot("/");
    }

    public static Path createRoot(String delimiter) {
        return new Path(delimiter);
    }

    public File toFile() {
        return new File(this.toString());
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Path) {
            return this.getRelative().equals(((Path)other).getRelative());
        }
        return false;
    }
}

