/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import com.yahoo.text.PositionedString;

public abstract class SimpleMapParser {
    private PositionedString s;

    public void parse(String string) {
        try {
            this.s = new PositionedString(string);
            this.s.consumeSpaces();
            this.s.consume('{');
            while (!this.s.peek('}')) {
                this.s.consumeSpaces();
                String key = this.consumeKey();
                this.s.consume(':');
                this.s.consumeSpaces();
                this.consumeValue(key);
                this.s.consumeOptional(',');
                this.s.consumeSpaces();
            }
            this.s.consume('}');
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("'" + String.valueOf(this.s) + "' is not a legal sparse vector string", e);
        }
    }

    private String consumeKey() {
        if (this.s.consumeOptional('\"')) {
            String key = this.s.consumeTo('\"');
            this.s.consume('\"');
            return key;
        }
        if (this.s.consumeOptional('\'')) {
            String key = this.s.consumeTo('\'');
            this.s.consume('\'');
            return key;
        }
        int keyEnd = this.findEndOfKey();
        if (keyEnd < 0) {
            throw new IllegalArgumentException("Expected a key followed by ':' " + this.s.at());
        }
        return this.s.consumeToPosition(keyEnd);
    }

    protected int findEndOfKey() {
        for (int peekI = this.s.position(); peekI < this.s.string().length(); ++peekI) {
            if (this.s.string().charAt(peekI) != ':' && this.s.string().charAt(peekI) != ',') continue;
            return peekI;
        }
        return -1;
    }

    protected int findEndOfValue() {
        for (int peekI = this.s.position(); peekI < this.s.string().length(); ++peekI) {
            if (this.s.string().charAt(peekI) != ',' && this.s.string().charAt(peekI) != '}') continue;
            return peekI;
        }
        return -1;
    }

    protected void consumeValue(String key) {
        int endOfValue = this.findEndOfValue();
        if (endOfValue < 0) {
            throw new IllegalArgumentException("Expected a value followed by ',' or '}' " + this.s.at());
        }
        try {
            this.handleKeyValue(key, this.s.substring(endOfValue));
            this.s.setPosition(endOfValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Expected a legal value from position " + this.s.position() + " to " + endOfValue + " but was '" + this.s.substring(endOfValue) + "'", e);
        }
    }

    public PositionedString string() {
        return this.s;
    }

    protected abstract void handleKeyValue(String var1, String var2);
}

