/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.Utf8;
import com.yahoo.text.Utf8Array;
import com.yahoo.text.Utf8String;

public class Identifier
extends Utf8Array {
    public Identifier(String s) {
        this(Utf8.toBytes(s));
    }

    public Identifier(AbstractUtf8Array utf8) {
        this(utf8.getBytes());
    }

    public Identifier(byte[] utf8) {
        super(Identifier.verify(utf8));
    }

    private static byte[] verify(byte[] utf8) {
        if (utf8.length > 0) {
            Identifier.verifyFirst(utf8[0], utf8);
            for (int i = 1; i < utf8.length; ++i) {
                Identifier.verifyAny(utf8[i], utf8);
            }
        }
        return utf8;
    }

    private static boolean verifyFirst(byte c, byte[] identifier) {
        if (!(c == 95 || c >= 97 && c <= 122 || c >= 65 && c <= 90)) {
            throw new IllegalArgumentException("Illegal starting character '" + (char)c + "' of identifier '" + new Utf8String(new Utf8Array(identifier)).toString() + "'.");
        }
        return true;
    }

    private static boolean verifyAny(byte c, byte[] identifier) {
        if (!(c == 95 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57)) {
            throw new IllegalArgumentException("Illegal character '" + (char)c + "' of identifier '" + new Utf8String(new Utf8Array(identifier)).toString() + "'.");
        }
        return true;
    }
}

