/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.impl;

import com.google.common.util.concurrent.Striped;
import com.yahoo.tensor.Label;
import com.yahoo.tensor.impl.LabelImpl;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;

public class LabelCache {
    public static final LabelCache GLOBAL = new LabelCache(128, 2000);
    public static final Label INVALID_INDEX_LABEL = new LabelImpl(-1L, null);
    private final ConcurrentMap<String, LabelWeakReference> byString = new ConcurrentHashMap<String, LabelWeakReference>();
    private final ConcurrentMap<Long, LabelWeakReference> byNumeric = new ConcurrentHashMap<Long, LabelWeakReference>();
    private final AtomicLong uniqueCounter = new AtomicLong(-2L);
    private final Striped<Lock> stripedLock;
    private final ReferenceQueue<Label> referenceQueue = new ReferenceQueue();
    private final Label[] smallIndex;

    LabelCache(int lockStripes, int smallIndexSize) {
        this.stripedLock = Striped.lock((int)lockStripes);
        this.smallIndex = this.createSmallIndexLabels(smallIndexSize);
    }

    private Label[] createSmallIndexLabels(int count) {
        Label[] labels = new Label[count];
        for (int i = 0; i < count; ++i) {
            labels[i] = new LabelImpl(i, String.valueOf(i));
        }
        return labels;
    }

    public Label getOrCreateLabel(String string) {
        Label existingLabel;
        if (string == null) {
            return INVALID_INDEX_LABEL;
        }
        if (this.validNumericIndex(string)) {
            try {
                long numeric = Long.parseLong(string, 10);
                if (numeric < (long)this.smallIndex.length) {
                    return this.smallIndex[(int)numeric];
                }
                return new LabelImpl(numeric, string);
            }
            catch (NumberFormatException numeric) {
                // empty catch block
            }
        }
        if ((existingLabel = this.getLabel(string)) != null) {
            return existingLabel;
        }
        return this.createLabel(string);
    }

    public Label getOrCreateLabel(long numeric) {
        if (numeric >= 0L) {
            if (numeric < (long)this.smallIndex.length) {
                return this.smallIndex[(int)numeric];
            }
            return new LabelImpl(numeric);
        }
        if (numeric == INVALID_INDEX_LABEL.asNumeric()) {
            return INVALID_INDEX_LABEL;
        }
        Label existingLabel = this.getLabel(numeric);
        if (existingLabel != null) {
            return existingLabel;
        }
        throw new IllegalArgumentException("No negative numeric label " + numeric);
    }

    private boolean validNumericIndex(String s) {
        if (s.isEmpty() || s.length() > 1 && s.charAt(0) == '0') {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private Label getLabel(long numeric) {
        LabelWeakReference weakReference = (LabelWeakReference)this.byNumeric.get(numeric);
        return weakReference != null ? (Label)weakReference.get() : null;
    }

    private Label getLabel(String string) {
        LabelWeakReference weakReference = (LabelWeakReference)this.byString.get(string);
        return weakReference != null ? (Label)weakReference.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Label createLabel(String string) {
        Lock lock = (Lock)this.stripedLock.get((Object)string);
        lock.lock();
        try {
            Label existingLabel = this.getLabel(string);
            if (existingLabel != null) {
                Label label = existingLabel;
                return label;
            }
            long newNumeric = this.uniqueCounter.getAndDecrement();
            LabelImpl newLabel = new LabelImpl(newNumeric, string);
            LabelWeakReference newReference = new LabelWeakReference(newLabel, this.referenceQueue);
            this.byString.put(string, newReference);
            this.byNumeric.put(newNumeric, newReference);
            LabelImpl labelImpl = newLabel;
            return labelImpl;
        }
        finally {
            lock.unlock();
            this.removeStaleReferences();
        }
    }

    private void removeStaleReferences() {
        LabelWeakReference staleReference = (LabelWeakReference)this.referenceQueue.poll();
        if (staleReference == null) {
            return;
        }
        this.byString.remove(staleReference.stringKey, staleReference);
        this.byNumeric.remove(staleReference.numericKey, staleReference);
        staleReference = (LabelWeakReference)this.referenceQueue.poll();
        if (staleReference == null) {
            return;
        }
        this.byString.remove(staleReference.stringKey, staleReference);
        this.byNumeric.remove(staleReference.numericKey, staleReference);
    }

    public int size() {
        return this.byString.size();
    }

    static class LabelWeakReference
    extends WeakReference<Label> {
        final String stringKey;
        final long numericKey;

        LabelWeakReference(Label label, ReferenceQueue<Label> referenceQueue) {
            super(label, referenceQueue);
            this.stringKey = label.asString();
            this.numericKey = label.asNumeric();
        }
    }
}

