/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.List;
import java.util.Objects;

public class Argmin<NAMETYPE extends Name>
extends CompositeTensorFunction<NAMETYPE> {
    private final TensorFunction<NAMETYPE> argument;
    private final List<String> dimensions;

    public Argmin(TensorFunction<NAMETYPE> argument) {
        this(argument, List.of());
    }

    public Argmin(TensorFunction<NAMETYPE> argument, String dimension) {
        this(argument, List.of(dimension));
    }

    public Argmin(TensorFunction<NAMETYPE> argument, List<String> dimensions) {
        Objects.requireNonNull(dimensions, "The dimensions cannot be null");
        this.argument = argument;
        this.dimensions = List.copyOf(dimensions);
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return List.of(this.argument);
    }

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Argmin must have 1 argument, got " + arguments.size());
        }
        return new Argmin<NAMETYPE>(arguments.get(0), this.dimensions);
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        PrimitiveTensorFunction<NAMETYPE> primitiveArgument = this.argument.toPrimitive();
        Reduce<NAMETYPE> reduce = new Reduce<NAMETYPE>(primitiveArgument, Reduce.Aggregator.min, this.dimensions);
        return new Join<NAMETYPE>(primitiveArgument, reduce, ScalarFunctions.equal());
    }

    @Override
    public String toString(ToStringContext<NAMETYPE> context) {
        return "argmin(" + this.argument.toString(context) + Reduce.commaSeparatedNames(this.dimensions, context) + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash("argmin", this.argument, this.dimensions);
    }
}

