/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactoryFactory {
    private static final Map<String, PooledFactory> factory = new HashMap<String, PooledFactory>();

    public static synchronized ThreadFactory getThreadFactory(String name) {
        PooledFactory p = factory.get(name);
        if (p == null) {
            p = new PooledFactory(name);
            factory.put(name, p);
        }
        return p.getFactory(false);
    }

    public static synchronized ThreadFactory getDaemonThreadFactory(String name) {
        PooledFactory p = factory.get(name);
        if (p == null) {
            p = new PooledFactory(name);
            factory.put(name, p);
        }
        return p.getFactory(true);
    }

    private static class PooledFactory {
        private final String name;
        private final AtomicInteger poolId = new AtomicInteger(1);

        PooledFactory(String name) {
            this.name = name;
        }

        ThreadFactory getFactory(boolean isDaemon) {
            return new Factory(this.name + "-" + this.poolId.getAndIncrement() + "-thread-", isDaemon);
        }

        private static class Factory
        implements ThreadFactory {
            final ThreadGroup group;
            final AtomicInteger threadNumber = new AtomicInteger(1);
            final String namePrefix;
            final boolean isDaemon;

            Factory(String name, boolean isDaemon) {
                this.isDaemon = isDaemon;
                SecurityManager s = System.getSecurityManager();
                this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
                this.namePrefix = name;
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
                if (t.isDaemon() != this.isDaemon) {
                    t.setDaemon(this.isDaemon);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        }
    }
}

