/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

final class DecodeIndex {
    private long[] data;
    private int reserved;
    private int used = 0;
    private final int totalSize;
    private final int rootOffset;

    private int binarySize() {
        return this.totalSize - this.rootOffset;
    }

    private int adjustSize(int minSize, int maxSize, int cnt, int byteOffset) {
        double expSize;
        double wantedSize;
        double density = (double)cnt / (double)(byteOffset - this.rootOffset);
        double estSize = 1.1 * density * (double)this.binarySize();
        double d = wantedSize = estSize > (expSize = 1.25 * (double)this.data.length) ? estSize : expSize;
        if (wantedSize < (double)minSize) {
            return minSize;
        }
        if (wantedSize > (double)maxSize) {
            return maxSize;
        }
        return (int)wantedSize;
    }

    DecodeIndex(int totalSize, int rootOffset) {
        this.totalSize = totalSize;
        this.rootOffset = rootOffset;
        int initialCapacity = Math.max(16, this.binarySize() / 24);
        this.data = new long[initialCapacity];
        this.reserved = 1;
    }

    long[] getBacking() {
        return this.data;
    }

    int tryReserveChildren(int n, int cnt, int byteOffset) {
        int offset = this.reserved;
        if (n > this.data.length - this.reserved) {
            int maxSize = this.totalSize - byteOffset + cnt;
            if (n > maxSize - this.reserved) {
                return -1;
            }
            long[] old = this.data;
            this.data = new long[this.adjustSize(this.reserved + n, maxSize, cnt, byteOffset)];
            System.arraycopy(old, 0, this.data, 0, this.reserved);
        }
        this.reserved += n;
        return offset;
    }

    int size() {
        return this.reserved;
    }

    int used() {
        return this.used;
    }

    int capacity() {
        return this.data.length;
    }

    void set(int idx, int byteOffset, int firstChild, int extBits) {
        this.data[idx] = (long)(byteOffset & Integer.MAX_VALUE) << 33 | (long)(firstChild & Integer.MAX_VALUE) << 2 | (long)(extBits & 3);
        ++this.used;
    }
}

