/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.Metric;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;

public final class DummyDocumentV1ApiHandler
extends ThreadedHttpRequestHandler {
    public DummyDocumentV1ApiHandler(Executor executor, Metric metrics) {
        super(executor, metrics);
    }

    public HttpResponse handle(HttpRequest request) {
        return new HttpErrorResponse(404, "Document API is not configured in this cluster. See https://docs.vespa.ai/en/reference/services/container.html#document-api");
    }

    private static class HttpErrorResponse
    extends HttpResponse {
        private final Slime slime = new Slime();

        public HttpErrorResponse(int code, String msg) {
            super(code);
            Cursor root = this.slime.setObject();
            root.setString("error-code", "NOT_FOUND");
            root.setString("message", msg);
        }

        public void render(OutputStream stream) throws IOException {
            new JsonFormat(true).encode(stream, this.slime);
        }

        public String getContentType() {
            return "application/json";
        }
    }
}

