/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.messagebus.Error;
import java.util.Collection;
import java.util.Set;

enum ErrorCode {
    OK(true, true),
    ERROR(false, false),
    TRANSIENT_ERROR(false, true),
    END_OF_FEED(true, true);

    private static final Collection<Integer> MBUS_FATALS_HANDLED_AS_TRANSIENT;
    private final boolean success;
    private final boolean _transient;

    private ErrorCode(boolean success, boolean _transient) {
        this.success = success;
        this._transient = _transient;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isTransient() {
        return this._transient;
    }

    static ErrorCode fromBusError(Error mbusError) {
        return mbusError.isFatal() && !MBUS_FATALS_HANDLED_AS_TRANSIENT.contains(mbusError.getCode()) ? ERROR : TRANSIENT_ERROR;
    }

    static {
        MBUS_FATALS_HANDLED_AS_TRANSIENT = Set.of(Integer.valueOf(200001), Integer.valueOf(200002), Integer.valueOf(200003), Integer.valueOf(200006), Integer.valueOf(200014), Integer.valueOf(200012), Integer.valueOf(200009));
    }
}

