/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.plugin;

import ai.vespa.hosted.api.TestDescriptor;
import ai.vespa.hosted.plugin.TestAnnotationAnalyzer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generateTestDescriptor", threadSafe=true)
public class GenerateTestDescriptorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        TestAnnotationAnalyzer analyzer = new TestAnnotationAnalyzer();
        this.analyzeTestClasses(analyzer);
        TestDescriptor descriptor = TestDescriptor.from((String)"1.0", analyzer.systemTests(), analyzer.stagingTests(), analyzer.stagingSetupTests(), analyzer.productionTests());
        this.writeDescriptorFile(descriptor);
    }

    private void analyzeTestClasses(TestAnnotationAnalyzer analyzer) throws MojoExecutionException {
        if (!Files.exists(this.testClassesDirectory(), new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.walk(this.testClassesDirectory(), new FileVisitOption[0]);){
            files.filter(f -> f.toString().endsWith(".class")).forEach(analyzer::analyzeClass);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to analyze test classes: " + e.getMessage(), e);
        }
    }

    private void writeDescriptorFile(TestDescriptor descriptor) throws MojoExecutionException {
        try {
            Path descriptorFile = this.testClassesDirectory().resolve("META-INF/ai.vespa/testDescriptor.json");
            Files.createDirectories(descriptorFile.getParent(), new FileAttribute[0]);
            Files.write(descriptorFile, descriptor.toJson().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write test descriptor file: " + e.getMessage(), (Exception)e);
        }
    }

    private Path testClassesDirectory() {
        return Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]);
    }
}

