/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.plugin;

import ai.vespa.hosted.plugin.AbstractVespaMojo;
import com.yahoo.component.Version;
import com.yahoo.text.XML;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.OptionalInt;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Element;

@Mojo(name="compileVersion")
public class CompileVersionMojo
extends AbstractVespaMojo {
    @Parameter(property="outputFile", defaultValue="target/vespa.compile.version")
    private String outputFile;

    @Override
    protected void doExecute() throws IOException {
        Version parentVersion;
        Path output = Paths.get(this.outputFile, new String[0]).toAbsolutePath();
        OptionalInt allowMajor = CompileVersionMojo.majorVersion(new File(this.project.getBasedir(), "src/main/application/deployment.xml").toPath());
        allowMajor.ifPresent(major -> this.getLog().info((CharSequence)("Allowing only major version " + major + ".")));
        Version compileVersion = Version.fromString((String)this.controller.compileVersion(this.id, allowMajor));
        MavenProject current = this.project;
        while (current.getParent() != null && current.getParent().getParentArtifact() != null) {
            current = current.getParent();
        }
        Artifact parentArtifact = current.getParentArtifact();
        if (parentArtifact != null && parentArtifact.getGroupId().matches("(com\\.yahoo\\.vespa|ai\\.vespa)(\\..+)?") && (parentVersion = Version.fromString((String)parentArtifact.getVersion())).compareTo(compileVersion) < 0) {
            throw new IllegalArgumentException("compile version (" + String.valueOf(compileVersion) + ") cannot be higher than parent version (" + String.valueOf(parentVersion) + ")");
        }
        this.getLog().info((CharSequence)("Vespa version to compile against is '" + compileVersion.toFullString() + "'."));
        this.getLog().info((CharSequence)("Writing compile version to '" + String.valueOf(output) + "'."));
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        Files.writeString(output, (CharSequence)compileVersion.toFullString(), new OpenOption[0]);
    }

    static OptionalInt majorVersion(Path deploymentXml) {
        try {
            String xml = Files.readString(deploymentXml);
            Element deploymentTag = XML.getDocument((String)xml).getDocumentElement();
            if (deploymentTag == null) {
                return OptionalInt.empty();
            }
            String allowMajor = deploymentTag.getAttribute("major-version");
            if (allowMajor.isEmpty()) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(CompileVersionMojo.parseMajor(allowMajor));
        }
        catch (NoSuchFileException ignored) {
            return OptionalInt.empty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int parseMajor(String s) {
        try {
            int major = Integer.parseInt(s);
            if (major < 1) {
                throw new IllegalArgumentException("Major version must be positive, got " + major);
            }
            return major;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid major version '" + s + "'", e);
        }
    }
}

