/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;

class SslContextBuilder {
    static final BouncyCastleProvider bcProvider = new BouncyCastleProvider();
    private Path certificateFile;
    private Path privateKeyFile;
    private Path caCertificatesFile;
    private Collection<X509Certificate> certificate;
    private PrivateKey privateKey;
    private Collection<X509Certificate> caCertificates;

    SslContextBuilder() {
    }

    SslContextBuilder withCertificateAndKey(Path certificate, Path privateKey) {
        this.certificateFile = certificate;
        this.privateKeyFile = privateKey;
        return this;
    }

    SslContextBuilder withCertificateAndKey(Collection<X509Certificate> certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.privateKey = privateKey;
        return this;
    }

    SslContextBuilder withCaCertificates(Path caCertificates) {
        this.caCertificatesFile = caCertificates;
        return this;
    }

    SslContextBuilder withCaCertificates(Collection<X509Certificate> caCertificates) {
        this.caCertificates = caCertificates;
        return this;
    }

    SSLContext build() throws IOException {
        try {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(null);
            if (this.hasCertificateFile()) {
                keystore.setKeyEntry("cert", SslContextBuilder.privateKey(this.privateKeyFile), new char[0], SslContextBuilder.certificates(this.certificateFile));
            } else if (this.hasCertificateInstance()) {
                keystore.setKeyEntry("cert", this.privateKey, new char[0], this.certificate.toArray(new Certificate[0]));
            }
            if (this.hasCaCertificateFile()) {
                SslContextBuilder.addCaCertificates(keystore, List.of(SslContextBuilder.certificates(this.caCertificatesFile)));
            } else if (this.hasCaCertificateInstance()) {
                SslContextBuilder.addCaCertificates(keystore, this.caCertificates);
            }
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            sslContext.init(this.createKeyManagers(keystore).orElse(null), this.createTrustManagers(keystore).orElse(null), null);
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    private boolean hasCertificateFile() {
        return this.certificateFile != null && this.privateKeyFile != null;
    }

    private boolean hasCertificateInstance() {
        return this.certificate != null && this.privateKey != null;
    }

    private boolean hasCaCertificateFile() {
        return this.caCertificatesFile != null;
    }

    private boolean hasCaCertificateInstance() {
        return this.caCertificates != null;
    }

    private Optional<KeyManager[]> createKeyManagers(KeyStore keystore) throws GeneralSecurityException {
        if (!this.hasCertificateInstance() && !this.hasCertificateFile()) {
            return Optional.empty();
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keystore, new char[0]);
        return Optional.of(kmf.getKeyManagers());
    }

    private Optional<TrustManager[]> createTrustManagers(KeyStore keystore) throws GeneralSecurityException {
        if (!this.hasCaCertificateInstance() && !this.hasCaCertificateFile()) {
            return Optional.empty();
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keystore);
        return Optional.of(tmf.getTrustManagers());
    }

    private static void addCaCertificates(KeyStore keystore, Collection<? extends Certificate> certificates) throws KeyStoreException {
        int i = 0;
        for (Certificate certificate : certificates) {
            keystore.setCertificateEntry("ca-cert-" + ++i, certificate);
        }
    }

    private static Certificate[] certificates(Path file) throws IOException, GeneralSecurityException {
        try (PEMParser parser = new PEMParser((Reader)Files.newBufferedReader(file));){
            Object pemObject;
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
            while ((pemObject = parser.readObject()) != null) {
                result.add(SslContextBuilder.toX509Certificate(pemObject));
            }
            if (result.isEmpty()) {
                throw new IOException("File contains no PEM encoded certificates: " + String.valueOf(file));
            }
            Certificate[] certificateArray = result.toArray(new Certificate[0]);
            return certificateArray;
        }
    }

    private static PrivateKey privateKey(Path file) throws IOException, GeneralSecurityException {
        try (PEMParser parser = new PEMParser((Reader)Files.newBufferedReader(file));){
            Object pemObject;
            while ((pemObject = parser.readObject()) != null) {
                if (pemObject instanceof PrivateKeyInfo) {
                    PrivateKeyInfo keyInfo = (PrivateKeyInfo)pemObject;
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyInfo.getEncoded());
                    PrivateKey privateKey = SslContextBuilder.createKeyFactory(keyInfo).generatePrivate(keySpec);
                    return privateKey;
                }
                if (!(pemObject instanceof PEMKeyPair)) continue;
                PEMKeyPair pemKeypair = (PEMKeyPair)pemObject;
                PrivateKeyInfo keyInfo = pemKeypair.getPrivateKeyInfo();
                PrivateKey privateKey = SslContextBuilder.createKeyFactory(keyInfo).generatePrivate(new PKCS8EncodedKeySpec(keyInfo.getEncoded()));
                return privateKey;
            }
            throw new IOException("Could not find private key in PEM file");
        }
    }

    private static X509Certificate toX509Certificate(Object pemObject) throws IOException, GeneralSecurityException {
        if (pemObject instanceof X509Certificate) {
            return (X509Certificate)pemObject;
        }
        if (pemObject instanceof X509CertificateHolder) {
            return new JcaX509CertificateConverter().setProvider((Provider)bcProvider).getCertificate((X509CertificateHolder)pemObject);
        }
        throw new IOException("Invalid type of PEM object: " + String.valueOf(pemObject));
    }

    private static KeyFactory createKeyFactory(PrivateKeyInfo info) throws IOException, GeneralSecurityException {
        ASN1ObjectIdentifier algorithm = info.getPrivateKeyAlgorithm().getAlgorithm();
        if (X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)algorithm)) {
            return KeyFactory.getInstance("EC", (Provider)bcProvider);
        }
        if (PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)algorithm)) {
            return KeyFactory.getInstance("RSA", (Provider)bcProvider);
        }
        throw new IOException("Unknown key algorithm: " + String.valueOf(algorithm));
    }
}

