/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Compression {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectory(File dir, String zipTopLevelDir) throws Exception {
        FileOutputStream zipFile = new FileOutputStream(new File(dir.getParent(), dir.getName() + ".zip"));
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(zipFile);){
            Compression.addDirectory(zipOutputStream, zipTopLevelDir, dir, "");
        }
    }

    private static void addDirectory(ZipOutputStream zipOutputStream, String zipTopLevelDir, File baseDir, String relativePath) throws IOException {
        File currentDir = new File(baseDir, relativePath);
        for (File child : currentDir.listFiles()) {
            if (child.isDirectory()) {
                Compression.addDirectory(zipOutputStream, zipTopLevelDir, baseDir, Compression.composePath(relativePath, child.getName()));
                continue;
            }
            Compression.addFile(zipOutputStream, zipTopLevelDir, relativePath, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFile(ZipOutputStream zipOutputStream, String zipTopLevelDir, String relativePath, File child) throws IOException {
        ZipEntry entry = new ZipEntry(Compression.composePath(zipTopLevelDir, Compression.composePath(relativePath, child.getName())));
        zipOutputStream.putNextEntry(entry);
        try (FileInputStream fileInput = new FileInputStream(child);){
            fileInput.transferTo(zipOutputStream);
        }
        finally {
            zipOutputStream.closeEntry();
        }
    }

    private static String composePath(String relativePath, String subDir) {
        return relativePath.isEmpty() ? subDir : relativePath + File.separator + subDir;
    }
}

