/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd;

import ai.vespa.hosted.cd.DisabledInInstances;
import ai.vespa.hosted.cd.TestRuntime;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

class DisabledInInstancesCondition
implements ExecutionCondition {
    DisabledInInstancesCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional annotation = AnnotationUtils.findAnnotation((Optional)context.getElement(), DisabledInInstances.class);
        if (annotation.isEmpty()) {
            return ConditionEvaluationResult.enabled((String)(DisabledInInstances.class.getSimpleName() + " is not present"));
        }
        List<String> disablingInstances = List.of(((DisabledInInstances)annotation.get()).value());
        String thisInstance = TestRuntime.get().application().instance();
        String reason = "Disabled in: %s. Current instance: %s.".formatted(disablingInstances.isEmpty() ? "no instances" : "instances " + String.join((CharSequence)", ", disablingInstances), thisInstance);
        return disablingInstances.contains(thisInstance) ? ConditionEvaluationResult.disabled((String)reason) : ConditionEvaluationResult.enabled((String)reason);
    }
}

