/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.hpke;

import com.yahoo.security.ArrayUtils;
import com.yahoo.security.hpke.Constants;
import com.yahoo.security.hpke.Kdf;

class LabeledKdfUtils {
    LabeledKdfUtils() {
    }

    static byte[] labeledExtractForSuite(Kdf kdf, byte[] suiteId, byte[] salt, byte[] label, byte[] ikm) {
        byte[] labeledIkm = ArrayUtils.concat(Constants.HPKE_V1_LABEL, suiteId, label, ikm);
        return kdf.extract(salt, labeledIkm);
    }

    static byte[] labeledExpandForSuite(Kdf kdf, byte[] prk, byte[] suiteId, byte[] label, byte[] info, int nBytesToExpand) {
        byte[] labeledInfo = ArrayUtils.concat(LabeledKdfUtils.i2osp2((short)nBytesToExpand), Constants.HPKE_V1_LABEL, suiteId, label, info);
        return kdf.expand(prk, labeledInfo, nBytesToExpand);
    }

    static byte[] i2osp2(short v) {
        return new byte[]{(byte)(v >>> 8), (byte)(v & 0xFF)};
    }
}

