/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation.hll;

import com.yahoo.searchlib.aggregation.hll.NormalSketch;
import com.yahoo.searchlib.aggregation.hll.Sketch;
import com.yahoo.searchlib.aggregation.hll.SparseSketch;

public class SketchMerger {
    public Sketch<?> merge(Sketch<?> left, Sketch<?> right) {
        if (left instanceof NormalSketch && right instanceof NormalSketch) {
            return this.mergeNormalWithNormal(SketchMerger.asNormal(left), SketchMerger.asNormal(right));
        }
        if (left instanceof NormalSketch && right instanceof SparseSketch) {
            return this.mergeNormalWithSparse(SketchMerger.asNormal(left), SketchMerger.asSparse(right));
        }
        if (left instanceof SparseSketch && right instanceof NormalSketch) {
            return this.mergeNormalWithSparse(SketchMerger.asNormal(right), SketchMerger.asSparse(left));
        }
        if (left instanceof SparseSketch && right instanceof SparseSketch) {
            return this.mergeSparseWithSparse(SketchMerger.asSparse(left), SketchMerger.asSparse(right));
        }
        throw new IllegalArgumentException(String.format("Invalid sketch types: left=%s, right=%s", ((Object)right).getClass(), ((Object)left).getClass()));
    }

    private Sketch<?> mergeSparseWithSparse(SparseSketch dest, SparseSketch other) {
        dest.merge(other);
        if (dest.size() > 256) {
            NormalSketch newSketch = new NormalSketch();
            newSketch.aggregate(dest.data());
            return newSketch;
        }
        return dest;
    }

    private NormalSketch mergeNormalWithNormal(NormalSketch dest, NormalSketch other) {
        dest.merge(other);
        return dest;
    }

    private NormalSketch mergeNormalWithSparse(NormalSketch dest, SparseSketch other) {
        NormalSketch newSketch = new NormalSketch();
        newSketch.aggregate(other.data());
        dest.merge(newSketch);
        return dest;
    }

    private static NormalSketch asNormal(Sketch<?> sketch) {
        return (NormalSketch)sketch;
    }

    private static SparseSketch asSparse(Sketch<?> sketch) {
        return (SparseSketch)sketch;
    }
}

