/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.searchlib.rankingexpression.evaluation.DoubleCompatibleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;

public class BooleanValue
extends DoubleCompatibleValue {
    private final boolean value;

    public static BooleanValue frozen(boolean value) {
        BooleanValue booleanValue = new BooleanValue(value);
        booleanValue.freeze();
        return booleanValue;
    }

    public BooleanValue(boolean value) {
        this.value = value;
    }

    @Override
    public boolean asBoolean() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public Value asMutable() {
        if (!this.isFrozen()) {
            return this;
        }
        return new BooleanValue(this.value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Value)) {
            return false;
        }
        if (!((Value)other).hasDouble()) {
            return false;
        }
        return this.value == ((Value)other).asBoolean();
    }

    @Override
    public int hashCode() {
        return this.value ? 1 : 3;
    }
}

