/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.IntegerResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.ResultNodeVector;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;

public class IntegerResultNodeVector
extends ResultNodeVector {
    public static final int classId = IntegerResultNodeVector.registerClass((int)16503, IntegerResultNodeVector.class, IntegerResultNodeVector::new);
    private ArrayList<IntegerResultNode> vector = new ArrayList();

    public IntegerResultNodeVector add(IntegerResultNode v) {
        this.vector.add(v);
        return this;
    }

    public ArrayList<IntegerResultNode> getVector() {
        return this.vector;
    }

    @Override
    public ResultNodeVector add(ResultNode r) {
        return this.add((IntegerResultNode)r);
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.vector.size());
        for (IntegerResultNode node : this.vector) {
            node.serialize(buf);
        }
    }

    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        int sz = buf.getInt(null);
        this.vector = new ArrayList();
        for (int i = 0; i < sz; ++i) {
            IntegerResultNode node = new IntegerResultNode(0L);
            node.deserialize(buf);
            this.vector.add(node);
        }
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        IntegerResultNodeVector b = (IntegerResultNodeVector)rhs;
        int minLength = this.vector.size();
        if (b.vector.size() < minLength) {
            minLength = b.vector.size();
        }
        int diff = 0;
        for (int i = 0; diff == 0 && i < minLength; ++i) {
            diff = this.vector.get(i).compareTo(b.vector.get(i));
        }
        return diff == 0 ? this.vector.size() - b.vector.size() : diff;
    }
}

