/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.opennlp;

import ai.vespa.opennlp.OpenNlpConfig;
import com.yahoo.component.annotation.Inject;
import com.yahoo.language.Linguistics;
import com.yahoo.language.detect.Detector;
import com.yahoo.language.opennlp.OpenNlpDetector;
import com.yahoo.language.opennlp.OpenNlpTokenizer;
import com.yahoo.language.process.Segmenter;
import com.yahoo.language.process.SegmenterImpl;
import com.yahoo.language.process.Stemmer;
import com.yahoo.language.process.StemmerImpl;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.simple.SimpleLinguistics;

public class OpenNlpLinguistics
extends SimpleLinguistics {
    private final boolean snowballStemmingForEnglish;
    private final boolean cjk;
    private final boolean createCjkGrams;
    private final Detector detector;

    public OpenNlpLinguistics() {
        this(new OpenNlpConfig.Builder().build());
    }

    @Inject
    public OpenNlpLinguistics(OpenNlpConfig config) {
        this.snowballStemmingForEnglish = config.snowballStemmingForEnglish();
        this.cjk = config.cjk();
        this.createCjkGrams = config.createCjkGrams();
        this.detector = new OpenNlpDetector();
    }

    public Tokenizer getTokenizer() {
        return new OpenNlpTokenizer(OpenNlpTokenizer.Mode.index, this.getNormalizer(), this.getTransformer(), this.snowballStemmingForEnglish, this.cjk, this.createCjkGrams);
    }

    public Stemmer getStemmer() {
        return new StemmerImpl(this.forQuerying(this.getTokenizer()));
    }

    public Segmenter getSegmenter() {
        return new SegmenterImpl(this.forQuerying(this.getTokenizer()));
    }

    public Detector getDetector() {
        return this.detector;
    }

    public boolean equals(Linguistics other) {
        return other instanceof OpenNlpLinguistics;
    }

    private Tokenizer forQuerying(Tokenizer tokenizer) {
        if (tokenizer.getClass() != OpenNlpTokenizer.class) {
            return tokenizer;
        }
        return ((OpenNlpTokenizer)tokenizer).withMode(OpenNlpTokenizer.Mode.query);
    }
}

