/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.opennlp;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import java.util.HashSet;
import java.util.Set;

public final class OpenNlpConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "5263ea89bec528554f3760f9bd086d62";
    public static final String CONFIG_DEF_NAME = "open-nlp";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.opennlp";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.opennlp", "snowballStemmingForEnglish bool default=false", "cjk bool default=false", "createCjkGrams bool default=true"};
    private final BooleanNode snowballStemmingForEnglish;
    private final BooleanNode cjk;
    private final BooleanNode createCjkGrams;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public OpenNlpConfig(Builder builder) {
        this(builder, true);
    }

    private OpenNlpConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for open-nlp must be initialized: " + builder.__uninitialized);
        }
        this.snowballStemmingForEnglish = builder.snowballStemmingForEnglish == null ? new BooleanNode(false) : new BooleanNode(builder.snowballStemmingForEnglish.booleanValue());
        this.cjk = builder.cjk == null ? new BooleanNode(false) : new BooleanNode(builder.cjk.booleanValue());
        this.createCjkGrams = builder.createCjkGrams == null ? new BooleanNode(true) : new BooleanNode(builder.createCjkGrams.booleanValue());
    }

    public boolean snowballStemmingForEnglish() {
        return this.snowballStemmingForEnglish.value();
    }

    public boolean cjk() {
        return this.cjk.value();
    }

    public boolean createCjkGrams() {
        return this.createCjkGrams.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(OpenNlpConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean snowballStemmingForEnglish = null;
        private Boolean cjk = null;
        private Boolean createCjkGrams = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(OpenNlpConfig config) {
            this.snowballStemmingForEnglish(config.snowballStemmingForEnglish());
            this.cjk(config.cjk());
            this.createCjkGrams(config.createCjkGrams());
        }

        private Builder override(Builder __superior) {
            if (__superior.snowballStemmingForEnglish != null) {
                this.snowballStemmingForEnglish(__superior.snowballStemmingForEnglish);
            }
            if (__superior.cjk != null) {
                this.cjk(__superior.cjk);
            }
            if (__superior.createCjkGrams != null) {
                this.createCjkGrams(__superior.createCjkGrams);
            }
            return this;
        }

        public Builder snowballStemmingForEnglish(boolean __value) {
            this.snowballStemmingForEnglish = __value;
            return this;
        }

        private Builder snowballStemmingForEnglish(String __value) {
            return this.snowballStemmingForEnglish(Boolean.valueOf(__value));
        }

        public Builder cjk(boolean __value) {
            this.cjk = __value;
            return this;
        }

        private Builder cjk(String __value) {
            return this.cjk(Boolean.valueOf(__value));
        }

        public Builder createCjkGrams(boolean __value) {
            this.createCjkGrams = __value;
            return this;
        }

        private Builder createCjkGrams(String __value) {
            return this.createCjkGrams(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return OpenNlpConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return OpenNlpConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return OpenNlpConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public OpenNlpConfig build() {
            return new OpenNlpConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

